/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.resolvers;

import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.jpa.javaee.JavaEEModuleInformer;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.jpa.resolvers.strategy.SearchStrategy;

public abstract class BasePersistenceUnitDependencyResolver
implements PersistenceUnitDependencyResolver {
    private JavaEEModuleInformer javaEEModuleInformer;
    private SearchStrategy strategy;

    protected BasePersistenceUnitDependencyResolver() {
    }

    protected BasePersistenceUnitDependencyResolver(SearchStrategy strategy) {
        assert (strategy != null) : "strategy is null";
        this.strategy = strategy;
    }

    public String createBeanName(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        assert (persistenceUnitName.indexOf(47) == -1);
        assert (persistenceUnitName.indexOf(35) == -1);
        String appName = this.javaEEModuleInformer.getApplicationName(deploymentUnit);
        String modulePath = this.javaEEModuleInformer.getModulePath(deploymentUnit);
        String unitName = (appName != null ? appName + "/" : "") + modulePath + "#" + persistenceUnitName;
        return "persistence.unit:unitName=" + unitName;
    }

    protected static DeploymentUnit getDeploymentUnit(DeploymentUnit current, String path) {
        if (path.startsWith("/")) {
            return BasePersistenceUnitDependencyResolver.getDeploymentUnit(current.getTopLevel(), path.substring(1));
        }
        if (path.startsWith("./")) {
            return BasePersistenceUnitDependencyResolver.getDeploymentUnit(current, path.substring(2));
        }
        if (path.startsWith("../")) {
            return BasePersistenceUnitDependencyResolver.getDeploymentUnit(current.getParent(), path.substring(3));
        }
        int i = path.indexOf(47);
        String name = i == -1 ? path : path.substring(0, i);
        for (DeploymentUnit child : current.getChildren()) {
            if (!child.getSimpleName().equals(name)) continue;
            return child;
        }
        throw new IllegalArgumentException("Can't find a deployment unit named " + name + " at " + current);
    }

    public String resolvePersistenceUnitSupplier(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        int i;
        int n = i = persistenceUnitName == null ? -1 : persistenceUnitName.indexOf(35);
        if (i != -1) {
            String path = persistenceUnitName.substring(0, i);
            String unitName = persistenceUnitName.substring(i + 1);
            DeploymentUnit targetDeploymentUnit = BasePersistenceUnitDependencyResolver.getDeploymentUnit(deploymentUnit, path);
            return this.createBeanName(targetDeploymentUnit, unitName);
        }
        if (this.strategy == null) {
            throw new IllegalStateException("No strategy was set on " + this);
        }
        String name = this.strategy.findPersistenceUnitSupplier(this, deploymentUnit, persistenceUnitName);
        if (name == null) {
            throw new IllegalArgumentException("Can't find a persistence unit named '" + persistenceUnitName + "' in " + deploymentUnit);
        }
        return name;
    }

    @Inject
    public void setJavaEEModuleInformer(JavaEEModuleInformer informer) {
        this.javaEEModuleInformer = informer;
    }

    protected void setSearchStrategy(SearchStrategy strategy) {
        assert (strategy != null) : "strategy is null";
        this.strategy = strategy;
    }
}

