/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;
import org.jboss.cache.eviction.MRUAlgorithm;

public class MRUAlgorithmConfig
extends EvictionAlgorithmConfigBase {
    private static final long serialVersionUID = -8734577898966155218L;

    public MRUAlgorithmConfig() {
        this.evictionAlgorithmClassName = MRUAlgorithm.class.getName();
        this.setMaxNodes(-1);
    }

    public MRUAlgorithmConfig(int maxNodes) {
        this.evictionAlgorithmClassName = MRUAlgorithm.class.getName();
        this.setMaxNodes(maxNodes);
    }

    public void validate() throws ConfigurationException {
        super.validate();
        if (this.getMaxNodes() < -1) {
            this.maxNodes = -1;
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("MRUAlgorithmConfig: ").append(" maxNodes =").append(this.getMaxNodes());
        return str.toString();
    }

    public void reset() {
        super.reset();
        this.setMaxNodes(-1);
        this.evictionAlgorithmClassName = MRUAlgorithm.class.getName();
    }

    public MRUAlgorithmConfig clone() throws CloneNotSupportedException {
        return (MRUAlgorithmConfig)super.clone();
    }
}

