/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.s3;

import java.io.BufferedInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import net.noderunner.amazon.s3.Bucket;
import net.noderunner.amazon.s3.Connection;
import net.noderunner.amazon.s3.Entry;
import net.noderunner.amazon.s3.GetStreamResponse;
import net.noderunner.amazon.s3.ListResponse;
import net.noderunner.amazon.s3.Response;
import net.noderunner.amazon.s3.S3Object;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.s3.S3Exception;
import org.jboss.cache.loader.s3.S3LoaderConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class S3CacheLoader
extends AbstractCacheLoader {
    private static final Log log = LogFactory.getLog(S3CacheLoader.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int PARENT_CACHE_SIZE = 100;
    private S3LoaderConfig config;
    private final char SEP = "/".charAt(0);
    private final char DEPTH_0 = (char)65;
    private Connection connection;
    private static Map<Class<?>, Character> prefix = new HashMap();
    private Set<Fqn> parents = Collections.synchronizedSet(new HashSet());
    private S3Object dummyObj;

    @Override
    public void start() throws Exception {
        log.debug((Object)"Starting");
        try {
            this.connection = this.config.getConnection();
            Response create = this.connection.create(this.getBucket(), this.config.getLocation());
            if (!create.isOk()) {
                throw new S3Exception("Unable to create bucket: " + create);
            }
            log.info((Object)("S3 accessed successfully. Bucket created: " + create));
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    @Override
    public void stop() {
        log.debug((Object)"stop");
        this.connection.shutdown();
    }

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = base instanceof S3LoaderConfig ? (S3LoaderConfig)base : new S3LoaderConfig(base);
        if (trace) {
            log.trace((Object)("config=" + this.config));
        }
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    private String key(Fqn fqn) {
        return this.key(fqn.size(), fqn).toString();
    }

    private String children(Fqn fqn) {
        return this.key(fqn.size() + 1, fqn).append(this.SEP).toString();
    }

    private StringBuilder key(int depth, Fqn fqn) {
        StringBuilder sb = new StringBuilder();
        List l = fqn.peekElements();
        sb.append((char)(65 + depth));
        for (Object o : l) {
            sb.append(this.SEP);
            if (o == null) {
                sb.append("_null");
                continue;
            }
            if (o instanceof String) {
                sb.append("_").append(o);
                continue;
            }
            Character c = prefix.get(o.getClass());
            if (c == null) {
                throw new IllegalArgumentException("not supported " + o.getClass());
            }
            sb.append(c.charValue()).append(o);
        }
        return sb;
    }

    public Set<String> getChildrenNames(Fqn name) throws Exception {
        String children = this.children(name);
        ListResponse response = this.connection.list(this.getBucket(), children);
        if (trace) {
            log.trace((Object)("getChildrenNames " + name + " response=" + response));
        }
        if (response.isNotFound()) {
            return null;
        }
        if (!response.isOk()) {
            throw new Exception("List failed " + response);
        }
        HashSet<String> set = new HashSet<String>();
        for (Entry e : response.getEntries()) {
            set.add(e.getKey().substring(children.length() + 1));
        }
        if (set.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map get(Fqn name) throws Exception {
        GetStreamResponse response = this.connection.getStream(this.getBucket(), this.key(name));
        try {
            if (trace) {
                log.trace((Object)("get " + name + " response=" + response));
            }
            if (response.isNotFound()) {
                Map map = null;
                return map;
            }
            if (!response.isOk()) {
                throw new S3Exception("get failed " + response);
            }
            BufferedInputStream is = new BufferedInputStream(response.getInputStream());
            Map map = (Map)this.getMarshaller().objectFromStream(is);
            response.release();
            Map map2 = map;
            return map2;
        }
        finally {
            response.release();
        }
    }

    private Bucket getBucket() {
        return this.config.getBucket();
    }

    @Override
    public boolean exists(Fqn name) throws Exception {
        Response response = this.connection.head(this.getBucket(), this.key(name));
        if (trace) {
            log.trace((Object)("exists " + name + " response=" + response));
        }
        return response.isOk();
    }

    private S3Object wrap(Map map) throws Exception {
        byte[] b = this.getMarshaller().objectToByteBuffer(map);
        return new S3Object(b);
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        Object oldValue;
        HashMap<Object, Object> map = this.get(name);
        if (map != null) {
            oldValue = map.put(key, value);
        } else {
            map = new HashMap<Object, Object>(Collections.singletonMap(key, value));
            oldValue = null;
        }
        this.put0(name, map);
        return oldValue;
    }

    private void put0(Fqn name, Map map) throws Exception {
        this.put0(name, this.wrap(map));
    }

    private void put0(Fqn name, S3Object obj) throws Exception {
        Response response = this.connection.put(this.getBucket(), this.key(name), obj);
        if (trace) {
            log.trace((Object)("put " + name + " obj=" + obj + " response=" + response));
        }
        this.ensureParent(name);
        if (!response.isOk()) {
            throw new S3Exception("Put failed " + response);
        }
    }

    private S3Object getDummy() throws Exception {
        if (this.dummyObj != null) {
            return this.dummyObj;
        }
        this.dummyObj = this.wrap(new HashMap(0));
        return this.dummyObj;
    }

    private void ensureParent(Fqn name) throws Exception {
        if (name.size() <= 1) {
            return;
        }
        Fqn parent = name.getParent();
        boolean cache = this.config.getParentCache();
        if (cache && this.parents.contains(parent)) {
            return;
        }
        if (!this.exists(parent)) {
            this.put0(parent, this.getDummy());
        }
        if (cache) {
            this.parents.add(parent);
            if (this.parents.size() > 100) {
                this.parents.clear();
            }
        }
        this.ensureParent(parent);
    }

    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        Map map = this.get(name);
        Object oldValue = map != null ? map.remove(key) : null;
        this.put0(name, map);
        return oldValue;
    }

    @Override
    public void put(Fqn name, Map<Object, Object> values) throws Exception {
        if (values == null) {
            values = Collections.emptyMap();
        }
        this.put0(name, values);
    }

    @Override
    public void remove(Fqn name) throws Exception {
        Set<String> children = this.getChildrenNames(name);
        if (children != null) {
            log.trace((Object)("remove children: " + children));
            for (String child : children) {
                this.remove(Fqn.fromRelativeElements(name, child));
            }
        }
        Response response = this.connection.delete(this.getBucket(), this.key(name));
        if (trace) {
            log.trace((Object)("delete " + name + " response=" + response));
        }
        if (!response.isOk() && !response.isNotFound()) {
            throw new S3Exception("delete failed " + response);
        }
        this.parents.remove(name);
    }

    @Override
    public void removeData(Fqn name) throws Exception {
        this.put0(name, this.getDummy());
    }

    static {
        prefix.put(Byte.class, Character.valueOf('B'));
        prefix.put(Character.class, Character.valueOf('C'));
        prefix.put(Double.class, Character.valueOf('D'));
        prefix.put(Float.class, Character.valueOf('F'));
        prefix.put(Integer.class, Character.valueOf('I'));
        prefix.put(Long.class, Character.valueOf('J'));
        prefix.put(Short.class, Character.valueOf('S'));
        prefix.put(Boolean.class, Character.valueOf('Z'));
    }
}

