/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.MessagingComponent;

public class JDBCSupport
implements MessagingComponent {
    private static final Logger log = Logger.getLogger(JDBCSupport.class);
    private static boolean trace = log.isTraceEnabled();
    protected DataSource ds;
    private TransactionManager tm;
    protected Properties sqlProperties;
    private Map defaultDMLStatements = new LinkedHashMap();
    private Map defaultDDLStatements = new LinkedHashMap();
    private boolean useNDBFailoverStrategy = false;
    protected boolean createTablesOnStartup = true;

    public JDBCSupport() {
        this.sqlProperties = new Properties();
    }

    public JDBCSupport(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup) {
        this();
        this.ds = ds;
        this.tm = tm;
        if (sqlProperties != null) {
            this.sqlProperties = sqlProperties;
        }
        this.createTablesOnStartup = createTablesOnStartup;
    }

    public JDBCSupport(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup, boolean useNDBFailoverStrategy) {
        this(ds, tm, sqlProperties, createTablesOnStartup);
        this.useNDBFailoverStrategy = useNDBFailoverStrategy;
    }

    public void start() throws Exception {
        if (this.ds == null) {
            return;
        }
        this.defaultDMLStatements.putAll(this.getDefaultDMLStatements());
        this.defaultDDLStatements.putAll(this.getDefaultDDLStatements());
        Properties sqlPropertiesCopy = new Properties();
        for (Map.Entry<Object, Object> entry : this.sqlProperties.entrySet()) {
            if (this.ignoreVerificationOnStartup((String)entry.getKey())) continue;
            sqlPropertiesCopy.put(entry.getKey(), entry.getValue());
        }
        for (String string : sqlPropertiesCopy.keySet()) {
            this.getSQLStatement(string);
        }
        if (!sqlPropertiesCopy.isEmpty()) {
            for (String string : this.defaultDMLStatements.keySet()) {
                if (this.sqlProperties.get(string) != null) continue;
                throw new IllegalStateException("SQL statement " + string + " is not specified in the SQL properties");
            }
            for (String string : this.defaultDDLStatements.keySet()) {
                if (sqlPropertiesCopy.get(string) != null) continue;
                throw new IllegalStateException("SQL statement " + string + " is not specified in the SQL properties");
            }
        }
        if (this.createTablesOnStartup) {
            this.createSchema();
        } else {
            log.debug((Object)("Schema is not being created as createTablesOnStartup=" + this.createTablesOnStartup));
        }
    }

    public void stop() throws Exception {
    }

    protected String getSQLStatement(String statementName) {
        String defaultStatement = (String)this.defaultDMLStatements.get(statementName);
        if (defaultStatement == null) {
            defaultStatement = (String)this.defaultDDLStatements.get(statementName);
        }
        if (defaultStatement == null) {
            throw new IllegalArgumentException("No such SQL statement: " + statementName);
        }
        return this.sqlProperties.getProperty(statementName, defaultStatement);
    }

    protected Map getDefaultDMLStatements() {
        return Collections.EMPTY_MAP;
    }

    protected Map getDefaultDDLStatements() {
        return Collections.EMPTY_MAP;
    }

    protected boolean ignoreVerificationOnStartup(String statementName) {
        return false;
    }

    protected void closeResultSet(ResultSet rs) {
        block3: {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable e) {
                    if (!trace) break block3;
                    log.trace((Object)"Failed to close result set", e);
                }
            }
        }
    }

    protected void closeStatement(Statement st) {
        block3: {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable e) {
                    if (!trace) break block3;
                    log.trace((Object)"Failed to close statement", e);
                }
            }
        }
    }

    protected void closeConnection(Connection conn) {
        block3: {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable e) {
                    if (!trace) break block3;
                    log.trace((Object)"Failed to close statement", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchema() throws Exception {
        Iterator i = this.defaultDDLStatements.keySet().iterator();
        while (i.hasNext()) {
            Object var9_8;
            Connection conn = null;
            Statement st = null;
            TransactionWrapper tx = new TransactionWrapper();
            try {
                conn = this.ds.getConnection();
                String statementName = (String)i.next();
                String statement = this.getSQLStatement(statementName);
                if (!"IGNORE".equals(statement)) {
                    try {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Executing: " + statement));
                        }
                        st = conn.createStatement();
                        st.executeUpdate(statement);
                    }
                    catch (Exception e) {
                        log.debug((Object)("Failed to execute: " + statement), (Throwable)e);
                        tx.exceptionOccurred();
                    }
                } else {
                    log.debug((Object)("createSchema ignoring statement for " + statementName));
                }
                var9_8 = null;
                this.closeStatement(st);
                this.closeConnection(conn);
            }
            catch (Throwable throwable) {
                var9_8 = null;
                this.closeStatement(st);
                this.closeConnection(conn);
                tx.end();
                throw throwable;
            }
            tx.end();
            {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class JDBCTxRunner2<T> {
        private static final int MAX_TRIES = 25;
        protected Connection conn;
        private boolean getConnectionFailed;
        private boolean getCommitFailed;

        protected JDBCTxRunner2() {
        }

        public T execute() throws Exception {
            T t;
            block8: {
                Transaction tx = JDBCSupport.this.tm.suspend();
                try {
                    try {
                        this.conn = JDBCSupport.this.ds.getConnection();
                        this.conn.setAutoCommit(false);
                    }
                    catch (Exception e) {
                        this.getConnectionFailed = true;
                        throw e;
                    }
                    T res = this.doTransaction();
                    this.conn.commit();
                    t = res;
                    Object var5_7 = null;
                    JDBCSupport.this.closeConnection(this.conn);
                    if (tx == null) break block8;
                }
                catch (Exception e) {
                    try {
                        try {
                            this.conn.rollback();
                        }
                        catch (Throwable t2) {
                            log.trace((Object)"Failed to rollback", t2);
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var5_8 = null;
                            JDBCSupport.this.closeConnection(this.conn);
                            if (tx == null) break block9;
                            JDBCSupport.this.tm.resume(tx);
                        }
                        throw throwable;
                    }
                }
                JDBCSupport.this.tm.resume(tx);
            }
            return t;
        }

        public T executeWithRetry() throws Exception {
            int tries = 0;
            while (true) {
                try {
                    T res = this.execute();
                    if (tries > 0) {
                        log.warn((Object)"Update worked after retry");
                    }
                    return res;
                }
                catch (SQLException e) {
                    this.rollback();
                    if (this.getCommitFailed && JDBCSupport.this.useNDBFailoverStrategy) {
                        log.warn((Object)("Ignoring SQL exception on retry after commit failed, SQLState " + e.getSQLState() + " code:" + e.getErrorCode() + "- assuming deadlock detected, try:" + (tries + 1)), (Throwable)e);
                        return null;
                    }
                    if (this.getConnectionFailed) {
                        throw e;
                    }
                    if ("08007".equals(e.getSQLState()) && JDBCSupport.this.useNDBFailoverStrategy) {
                        this.getCommitFailed = true;
                    }
                    log.warn((Object)("SQLException caught, SQLState " + e.getSQLState() + " code:" + e.getErrorCode() + "- assuming deadlock detected, try:" + (tries + 1)), (Throwable)e);
                    if (++tries == 25) {
                        log.error((Object)("Retried " + tries + " times, now giving up"));
                        throw new IllegalStateException("Failed to execute transaction");
                    }
                    log.warn((Object)"Trying again after a pause");
                    Thread.sleep((long)(Math.random() * 500.0));
                    continue;
                }
                break;
            }
        }

        public void rollback() {
        }

        public abstract T doTransaction() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class JDBCTxRunner<T> {
        private static final int MAX_TRIES = 25;
        protected Connection conn;
        private TransactionWrapper wrap;

        protected JDBCTxRunner() {
        }

        public T execute() throws Exception {
            T t;
            this.wrap = new TransactionWrapper();
            try {
                this.conn = JDBCSupport.this.ds.getConnection();
                t = this.doTransaction();
                Object var3_3 = null;
            }
            catch (Exception e) {
                try {
                    this.wrap.exceptionOccurred();
                    throw e;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.wrap.end();
                    JDBCSupport.this.closeConnection(this.conn);
                    throw throwable;
                }
            }
            this.wrap.end();
            JDBCSupport.this.closeConnection(this.conn);
            return t;
        }

        public T executeWithRetry() throws Exception {
            int tries = 0;
            while (true) {
                try {
                    T res = this.execute();
                    if (tries > 0) {
                        log.warn((Object)"Update worked after retry");
                    }
                    return res;
                }
                catch (SQLException e) {
                    log.warn((Object)("SQLException caught, SQLState " + e.getSQLState() + " code:" + e.getErrorCode() + "- assuming deadlock detected, try:" + (tries + 1)), (Throwable)e);
                    if (++tries == 25) {
                        log.error((Object)("Retried " + tries + " times, now giving up"));
                        throw new IllegalStateException("Failed to excecute transaction");
                    }
                    log.warn((Object)"Trying again after a pause");
                    Thread.sleep((long)(Math.random() * 500.0));
                    continue;
                }
                break;
            }
        }

        public abstract T doTransaction() throws Exception;
    }

    protected class TransactionWrapper {
        private Transaction oldTx;
        private boolean failed;

        public TransactionWrapper() throws Exception {
            this.oldTx = JDBCSupport.this.tm.suspend();
            JDBCSupport.this.tm.begin();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() throws Exception {
            try {
                if (1 == JDBCSupport.this.tm.getStatus()) {
                    this.failed = true;
                    if (trace) {
                        log.trace((Object)"Rolling back tx");
                    }
                    JDBCSupport.this.tm.rollback();
                } else {
                    if (trace) {
                        log.trace((Object)"Committing tx");
                    }
                    JDBCSupport.this.tm.commit();
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.oldTx != null && JDBCSupport.this.tm != null) {
                    if (trace) {
                        log.trace((Object)"Resuming tx");
                    }
                    JDBCSupport.this.tm.resume(this.oldTx);
                }
                throw throwable;
            }
            if (this.oldTx != null && JDBCSupport.this.tm != null) {
                if (trace) {
                    log.trace((Object)"Resuming tx");
                }
                JDBCSupport.this.tm.resume(this.oldTx);
            }
        }

        public void exceptionOccurred() throws Exception {
            JDBCSupport.this.tm.setRollbackOnly();
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

