/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.impl.postoffice.ClusterRequest;
import org.jboss.messaging.core.impl.postoffice.MappingInfo;
import org.jboss.messaging.core.impl.postoffice.RequestTarget;

class UnbindRequest
extends ClusterRequest {
    private static final Logger log = Logger.getLogger(UnbindRequest.class);
    private MappingInfo mappingInfo;
    private boolean allNodes;

    UnbindRequest() {
    }

    UnbindRequest(MappingInfo mappingInfo, boolean allNodes) {
        this.mappingInfo = mappingInfo;
        this.allNodes = allNodes;
    }

    Object execute(RequestTarget office) throws Exception {
        try {
            office.removeBindingFromCluster(this.mappingInfo, this.allNodes);
        }
        catch (Throwable t) {
            String s = "Failed to remove binding";
            log.error((Object)"Failed to remove binding", t);
            throw new Exception("Failed to remove binding", t);
        }
        return null;
    }

    byte getType() {
        return 4;
    }

    public void read(DataInputStream in) throws Exception {
        this.mappingInfo = new MappingInfo();
        this.mappingInfo.read(in);
        this.allNodes = in.readBoolean();
    }

    public void write(DataOutputStream out) throws Exception {
        this.mappingInfo.write(out);
        out.writeBoolean(this.allNodes);
    }
}

