/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.jmx;

import javax.transaction.TransactionManager;
import org.jboss.messaging.core.contract.MessagingComponent;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.impl.JDBCPersistenceManager;
import org.jboss.messaging.core.jmx.JDBCServiceSupport;
import org.jboss.messaging.util.ExceptionUtil;

public class JDBCPersistenceManagerService
extends JDBCServiceSupport {
    private PersistenceManager persistenceManager;
    private boolean started;
    private boolean usingBatchUpdates;
    private boolean usingBinaryStream = true;
    private boolean usingTrailingByte;
    private int maxParams = 100;
    private boolean supportsBlobOnSelect = true;
    private boolean supportsSetNullOnBlobs = true;
    private boolean detectDuplicates = false;
    private int idCacheSize = 500;
    private boolean useNDBFailoverStrategy = false;

    public MessagingComponent getInstance() {
        return this.persistenceManager;
    }

    protected synchronized void startService() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Service is already started");
        }
        super.startService();
        try {
            TransactionManager tm = this.getTransactionManagerReference();
            this.persistenceManager = new JDBCPersistenceManager(this.ds, tm, this.sqlProperties, this.createTablesOnStartup, this.usingBatchUpdates, this.usingBinaryStream, this.usingTrailingByte, this.maxParams, this.supportsBlobOnSelect, this.supportsSetNullOnBlobs, this.detectDuplicates, this.useNDBFailoverStrategy, this.idCacheSize);
            this.persistenceManager.start();
            this.started = true;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " startService");
        }
    }

    protected void stopService() throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Service is not started");
        }
        try {
            this.persistenceManager.stop();
            this.persistenceManager = null;
            this.started = false;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, (Object)((Object)this) + " startService");
        }
        this.log.debug((Object)((Object)((Object)this) + " stopped"));
    }

    public boolean isUsingBatchUpdates() {
        return this.usingBatchUpdates;
    }

    public void setUsingBatchUpdates(boolean b) {
        this.usingBatchUpdates = b;
    }

    public int getMaxParams() {
        return this.maxParams;
    }

    public void setMaxParams(int maxParams) {
        this.maxParams = maxParams;
    }

    public boolean isUseNDBFailoverStrategy() {
        return this.useNDBFailoverStrategy;
    }

    public void setUseNDBFailoverStrategy(boolean useNDBFailoverStrategy) {
        this.useNDBFailoverStrategy = useNDBFailoverStrategy;
    }

    public boolean isUsingBinaryStream() {
        return this.usingBinaryStream;
    }

    public void setUsingBinaryStream(boolean b) {
        this.usingBinaryStream = b;
    }

    public boolean isUsingTrailingByte() {
        return this.usingTrailingByte;
    }

    public void setUsingTrailingByte(boolean b) {
        this.usingTrailingByte = b;
    }

    public boolean isSupportsBlobOnSelect() {
        return this.supportsBlobOnSelect;
    }

    public void setSupportsBlobOnSelect(boolean b) {
        this.supportsBlobOnSelect = b;
    }

    public boolean isDetectDuplicates() {
        return this.detectDuplicates;
    }

    public void setDetectDuplicates(boolean detectDuplicates) {
        this.detectDuplicates = detectDuplicates;
    }

    public boolean isSupportsSetNullOnBlobs() {
        return this.supportsSetNullOnBlobs;
    }

    public void setSupportsSetNullOnBlobs(boolean supportsSetNullOnBlobs) {
        this.supportsSetNullOnBlobs = supportsSetNullOnBlobs;
    }

    public int getIDCacheSize() {
        return this.idCacheSize;
    }

    public void setIDCacheSize(int idCacheSize) {
        this.idCacheSize = idCacheSize;
    }
}

