/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.jmx;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.modules.jmx.XDocletModulesJmxMessages;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.MethodTagsHandler;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XConstructor;
import xjavadoc.XMethod;
import xjavadoc.XTag;

public class JMXTagsHandler
extends AbstractProgramElementTagsHandler {
    protected MethodTagsHandler handler = new MethodTagsHandler();
    protected Map attributes = Collections.synchronizedMap(new HashMap());
    protected int index = 0;

    public String mbeanName() throws XDocletException {
        return this.getMBeanName(JMXTagsHandler.getCurrentClass());
    }

    public void ifIsGetterMethod(String template, Properties attributes) throws XDocletException {
        if (this.isGetterMethod()) {
            this.generate(template);
        }
    }

    public void ifIsSetterMethod(String template, Properties attributes) throws XDocletException {
        if (this.isSetterMethod()) {
            this.generate(template);
        }
    }

    public void ifHasAttributeDescription(String template, Properties attributes) throws XDocletException {
        boolean hasGetterMethod = false;
        String name = this.handler.methodNameWithoutPrefix();
        String description = JMXTagsHandler.getTagValue((int)1, (String)"jmx:managed-attribute", (String)"description", null, null, (boolean)true, (boolean)false);
        List methods = JMXTagsHandler.getCurrentClass().getMethods();
        for (XMethod method : methods) {
            if (!method.getName().equals("get" + name) && !method.getName().equals("is" + name)) continue;
            hasGetterMethod = true;
        }
        if (this.isSetterMethod() && !hasGetterMethod || this.isGetterMethod()) {
            attributes.put(name, description);
            this.generate(template);
        }
    }

    public void forAllIndexedMethodParams(String template, Properties attributes) throws XDocletException {
        List tags = JMXTagsHandler.getCurrentMethod().getDoc().getTags("jmx:managed-operation-parameter");
        this.index = 0;
        for (int i = 0; i < tags.size(); ++i) {
            this.generate(template);
            ++this.index;
        }
    }

    public void forAllIndexedConstructorParams(String template, Properties attributes) throws XDocletException {
        List tags = JMXTagsHandler.getCurrentConstructor().getDoc().getTags("jmx:managed-constructor-parameter");
        this.index = 0;
        for (int i = 0; i < tags.size(); ++i) {
            this.generate(template);
            ++this.index;
        }
    }

    public String indexedMethodParamValue(Properties attributes) throws XDocletException {
        String tagName = attributes.getProperty("tagName");
        String paramName = attributes.getProperty("paramName");
        if (tagName == null || paramName == null) {
            throw new XDocletException(Translator.getString(XDocletModulesJmxMessages.class, (String)"MISSING_ATTRIBUTE"));
        }
        List<Object> tags = Arrays.asList(JMXTagsHandler.getCurrentMethod().getDoc().getTags(tagName).toArray());
        XTag tag = (XTag)tags.get(this.index);
        String tagContent = tag.getValue();
        int begin = tagContent.indexOf(paramName + "=\"") + paramName.length() + 2;
        int end = tagContent.indexOf("\"", begin);
        return tagContent.substring(begin, end);
    }

    public String indexedConstructorParamValue(Properties attributes) throws XDocletException {
        if (attributes == null) {
            throw new XDocletException(Translator.getString(XDocletModulesJmxMessages.class, (String)"MISSING_ATTRIBUTE"));
        }
        String tagName = attributes.getProperty("tagName");
        String paramName = attributes.getProperty("paramName");
        if (tagName == null || paramName == null) {
            throw new XDocletException(Translator.getString(XDocletModulesJmxMessages.class, (String)"MISSING_ATTRIBUTE"));
        }
        List<Object> tags = Arrays.asList(JMXTagsHandler.getCurrentConstructor().getDoc().getTags(tagName).toArray());
        XTag tag = (XTag)tags.get(this.index);
        String tagContent = tag.getValue();
        int begin = tagContent.indexOf(paramName + "=\"") + paramName.length() + 2;
        int end = tagContent.indexOf("\"", begin);
        return tagContent.substring(begin, end);
    }

    public String constructorSignature() throws XDocletException {
        XConstructor currentConstructor = JMXTagsHandler.getCurrentConstructor();
        String signature = currentConstructor.getSignature(false);
        while (signature.indexOf(" ") != -1) {
            int index = signature.indexOf(" ");
            String before = signature.substring(0, index);
            String after = signature.substring(index + 1, signature.length());
            signature = before + after;
        }
        return "public " + currentConstructor.getName() + signature;
    }

    protected String getMBeanName(XClass clazz) throws XDocletException {
        XTag bean_tag = clazz.getDoc().getTag("jmx:mbean");
        if (bean_tag == null) {
            throw new XDocletException(Translator.getString(XDocletMessages.class, (String)"CLASS_TAG_EXPECTED", (String[])new String[]{"@jmx:mbean", clazz.getQualifiedName()}));
        }
        String param_val = bean_tag.getAttributeValue("name");
        if (param_val == null) {
            throw new XDocletException(Translator.getString(XDocletMessages.class, (String)"CLASS_TAG_PARAMETER_EXPECTED", (String[])new String[]{"name", "@jmx:mbean", clazz.getQualifiedName()}));
        }
        return param_val;
    }

    protected boolean isGetterMethod() {
        String methodName = JMXTagsHandler.getCurrentMethod().getName();
        XClass retType = JMXTagsHandler.getCurrentMethod().getReturnType().getType();
        List params = JMXTagsHandler.getCurrentMethod().getParameters();
        return !retType.getQualifiedName().equals("void") && params.size() == 0 && (methodName.startsWith("get") || methodName.startsWith("is") && retType.getQualifiedName().equals("boolean"));
    }

    protected boolean isSetterMethod() {
        String methodName = JMXTagsHandler.getCurrentMethod().getName();
        XClass retType = JMXTagsHandler.getCurrentMethod().getReturnType().getType();
        List params = JMXTagsHandler.getCurrentMethod().getParameters();
        return retType.getQualifiedName().equals("void") && params.size() == 1 && methodName.startsWith("set");
    }
}

