/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOptionalRealDeployer<T>
extends AbstractRealDeployer {
    private Class<T> optionalInput;
    private boolean disableOptional;

    public AbstractOptionalRealDeployer(Class<T> optionalInput) {
        if (optionalInput == null) {
            throw new IllegalArgumentException("Null optional Input");
        }
        this.optionalInput = optionalInput;
        this.setInputs(optionalInput);
    }

    public void setDisableOptional(boolean disableOptional) {
        this.disableOptional = disableOptional;
    }

    @Override
    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        Object deployment = unit.getAttachment(this.optionalInput);
        if (!this.disableOptional || deployment != null) {
            this.deploy(unit, deployment);
        }
    }

    public abstract void deploy(DeploymentUnit var1, T var2) throws DeploymentException;

    @Override
    public void internalUndeploy(DeploymentUnit unit) {
        Object deployment = unit.getAttachment(this.optionalInput);
        if (!this.disableOptional || deployment != null) {
            this.undeploy(unit, deployment);
        }
    }

    public void undeploy(DeploymentUnit unit, T deployment) {
    }
}

