/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.streambuffer;

public final class AccessibleStringBuilder {
    char[] value;
    int count;

    public AccessibleStringBuilder() {
        this(32);
    }

    public AccessibleStringBuilder(int capacity) {
        this.value = new char[capacity];
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.value.length) {
            this.expandCapacity(newLength);
        }
        if (this.count < newLength) {
            while (this.count < newLength) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        } else {
            this.count = newLength;
        }
    }

    public AccessibleStringBuilder append(char[] str) {
        int newCount = this.count + str.length;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(str, 0, this.value, this.count, str.length);
        this.count = newCount;
        return this;
    }

    public AccessibleStringBuilder append(char[] str, int offset, int len) {
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newCount;
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public char[] getValue() {
        return this.value;
    }
}

