/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html.filters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.cyberneko.html.HTMLEventInfo;
import org.cyberneko.html.filters.DefaultFilter;
import org.cyberneko.html.filters.NamespaceBinder;

public class Purifier
extends DefaultFilter {
    public static final String SYNTHESIZED_NAMESPACE_PREFX = "http://cyberneko.org/html/ns/synthesized/";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://cyberneko.org/html/features/augmentations"};
    private static final Boolean[] RECOGNIZED_FEATURES_DEFAULTS = new Boolean[]{null, null};
    protected static final HTMLEventInfo SYNTHESIZED_ITEM = new HTMLEventInfo.SynthesizedItem();
    protected boolean fNamespaces;
    protected boolean fAugmentations;
    protected boolean fSeenDoctype;
    protected boolean fSeenRootElement;
    protected boolean fInCDATASection;
    protected String fPublicId;
    protected String fSystemId;
    protected NamespaceContext fNamespaceContext;
    protected int fSynthesizedNamespaceCount;
    private QName fQName = new QName();
    private final Augmentations fInfosetAugs = new AugmentationsImpl();
    private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();

    @Override
    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fInCDATASection = false;
        this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        this.fAugmentations = xMLComponentManager.getFeature(AUGMENTATIONS);
    }

    @Override
    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.fNamespaceContext = this.fNamespaces ? new NamespaceBinder.NamespaceSupport() : null;
        this.fSynthesizedNamespaceCount = 0;
        this.handleStartDocument();
        super.startDocument(xMLLocator, string, augmentations);
    }

    @Override
    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fNamespaceContext = namespaceContext;
        this.fSynthesizedNamespaceCount = 0;
        this.handleStartDocument();
        super.startDocument(xMLLocator, string, namespaceContext, augmentations);
    }

    @Override
    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (string == null || !string.equals("1.0")) {
            string = "1.0";
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null) {
            string3 = !string3.equalsIgnoreCase("true") && !string3.equalsIgnoreCase("false") ? null : string3.toLowerCase();
        }
        super.xmlDecl(string, string2, string3, augmentations);
    }

    @Override
    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        StringBuffer stringBuffer = new StringBuffer(this.purifyText(xMLString).toString());
        int n = stringBuffer.length();
        for (int i = n - 1; i >= 0; --i) {
            char c = stringBuffer.charAt(i);
            if (c != '-') continue;
            stringBuffer.insert(i + 1, ' ');
        }
        this.fStringBuffer.length = 0;
        this.fStringBuffer.append(stringBuffer.toString());
        xMLString = this.fStringBuffer;
        super.comment(xMLString, augmentations);
    }

    @Override
    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        string = this.purifyName(string, true);
        xMLString = this.purifyText(xMLString);
        super.processingInstruction(string, xMLString, augmentations);
    }

    @Override
    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.fSeenDoctype = true;
        this.fPublicId = string2;
        this.fSystemId = string3;
        if (this.fPublicId != null && this.fSystemId == null) {
            this.fSystemId = "";
        }
    }

    @Override
    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.handleStartElement(qName, xMLAttributes);
        super.startElement(qName, xMLAttributes, augmentations);
    }

    @Override
    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.handleStartElement(qName, xMLAttributes);
        super.emptyElement(qName, xMLAttributes, augmentations);
    }

    @Override
    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATASection = true;
        super.startCDATA(augmentations);
    }

    @Override
    public void endCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATASection = false;
        super.endCDATA(augmentations);
    }

    @Override
    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        xMLString = this.purifyText(xMLString);
        if (this.fInCDATASection) {
            StringBuffer stringBuffer = new StringBuffer(xMLString.toString());
            int n = stringBuffer.length();
            for (int i = n - 1; i >= 0; --i) {
                char c = stringBuffer.charAt(i);
                if (c != ']') continue;
                stringBuffer.insert(i + 1, ' ');
            }
            this.fStringBuffer.length = 0;
            this.fStringBuffer.append(stringBuffer.toString());
            xMLString = this.fStringBuffer;
        }
        super.characters(xMLString, augmentations);
    }

    @Override
    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        qName = this.purifyQName(qName);
        if (this.fNamespaces && qName.prefix != null && qName.uri == null) {
            qName.uri = this.fNamespaceContext.getURI(qName.prefix);
        }
        super.endElement(qName, augmentations);
    }

    protected void handleStartDocument() {
        this.fSeenDoctype = false;
        this.fSeenRootElement = false;
    }

    protected void handleStartElement(QName qName, XMLAttributes xMLAttributes) {
        qName = this.purifyQName(qName);
        int n = xMLAttributes != null ? xMLAttributes.getLength() : 0;
        for (int i = n - 1; i >= 0; --i) {
            xMLAttributes.getName(i, this.fQName);
            xMLAttributes.setName(i, this.purifyQName(this.fQName));
            if (!this.fNamespaces || this.fQName.rawname.equals("xmlns") || this.fQName.rawname.startsWith("xmlns:")) continue;
            xMLAttributes.getName(i, this.fQName);
            if (this.fQName.prefix == null || this.fQName.uri != null) continue;
            this.synthesizeBinding(xMLAttributes, this.fQName.prefix);
        }
        if (this.fNamespaces && qName.prefix != null && qName.uri == null) {
            this.synthesizeBinding(xMLAttributes, qName.prefix);
        }
        if (!this.fSeenRootElement && this.fSeenDoctype) {
            Augmentations augmentations = this.synthesizedAugs();
            super.doctypeDecl(qName.rawname, this.fPublicId, this.fSystemId, augmentations);
        }
        this.fSeenRootElement = true;
    }

    protected void synthesizeBinding(XMLAttributes xMLAttributes, String string) {
        String string2 = "xmlns";
        String string3 = string;
        String string4 = string2 + ':' + string3;
        String string5 = "http://cyberneko.org/html/properties/namespaces-uri";
        String string6 = "CDATA";
        String string7 = SYNTHESIZED_NAMESPACE_PREFX + this.fSynthesizedNamespaceCount++;
        this.fQName.setValues(string2, string3, string4, string5);
        xMLAttributes.addAttribute(this.fQName, string6, string7);
        this.fNamespaceContext.declarePrefix(string, string7);
    }

    protected final Augmentations synthesizedAugs() {
        Augmentations augmentations = null;
        if (this.fAugmentations) {
            augmentations = this.fInfosetAugs;
            Class<?> clazz = augmentations.getClass();
            Method method = null;
            try {
                method = clazz.getMethod("clear", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = clazz.getMethod("removeAllItems", null);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    augmentations = new AugmentationsImpl();
                }
            }
            if (method != null) {
                try {
                    method.invoke((Object)augmentations, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    augmentations = new AugmentationsImpl();
                }
                catch (InvocationTargetException invocationTargetException) {
                    augmentations = new AugmentationsImpl();
                }
            }
            augmentations.putItem(AUGMENTATIONS, (Object)SYNTHESIZED_ITEM);
        }
        return augmentations;
    }

    protected QName purifyQName(QName qName) {
        qName.prefix = this.purifyName(qName.prefix, true);
        qName.localpart = this.purifyName(qName.localpart, true);
        qName.rawname = this.purifyName(qName.rawname, false);
        return qName;
    }

    protected String purifyName(String string, boolean bl) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl2 = bl;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (i == 0) {
                if (!XMLChar.isNameStart((int)c)) {
                    stringBuffer.append("_u" + Purifier.toHexString(c, 4) + "_");
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (this.fNamespaces && c == ':' && bl2 || !XMLChar.isName((int)c)) {
                stringBuffer.append("_u" + Purifier.toHexString(c, 4) + "_");
            } else {
                stringBuffer.append(c);
            }
            bl2 = bl2 || c == ':';
        }
        return stringBuffer.toString();
    }

    protected XMLString purifyText(XMLString xMLString) {
        this.fStringBuffer.length = 0;
        for (int i = 0; i < xMLString.length; ++i) {
            char c = xMLString.ch[xMLString.offset + i];
            if (XMLChar.isInvalid((int)c)) {
                this.fStringBuffer.append("\\u" + Purifier.toHexString(c, 4));
                continue;
            }
            this.fStringBuffer.append(c);
        }
        return this.fStringBuffer;
    }

    protected static String toHexString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(Integer.toHexString(n));
        int n3 = n2 - stringBuffer.length();
        for (int i = 0; i < n3; ++i) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString().toUpperCase();
    }
}

