/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import org.apache.ws.jaxme.xs.XSAnnotation;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.impl.XSOpenAttrsImpl;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.types.XSAnySimpleType;
import org.apache.ws.jaxme.xs.xml.XsAnyURI;
import org.apache.ws.jaxme.xs.xml.XsEAnnotation;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsFormChoice;
import org.apache.ws.jaxme.xs.xml.XsNCName;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.apache.ws.jaxme.xs.xml.XsTAttribute;
import org.apache.ws.jaxme.xs.xml.XsTLocalSimpleType;
import org.xml.sax.SAXException;

public class XSAttributeImpl
extends XSOpenAttrsImpl
implements XSAttribute {
    private final XsQName name;
    private final XsEAnnotation xsAnnotation;
    private final boolean isGlobal;
    private XSAnnotation[] annotations;
    private boolean isValidated;
    private XSType type;

    protected XsTAttribute getXsTAttribute() {
        return (XsTAttribute)this.getXsObject();
    }

    protected boolean isReference() {
        return this.getXsTAttribute().getRef() != null;
    }

    protected boolean isInnerSimpleType() {
        return this.getXsTAttribute().getSimpleType() != null;
    }

    protected XSAttributeImpl(XSObject pParent, XsTAttribute pBaseAttribute) throws SAXException {
        super(pParent, pBaseAttribute);
        if (this.isReference()) {
            this.name = pBaseAttribute.getRef();
            this.isGlobal = pBaseAttribute.isGlobal();
        } else {
            String namespacePrefix;
            XsAnyURI namespace;
            XsNCName myName = pBaseAttribute.getName();
            if (myName == null) {
                throw new LocSAXException("Invalid attribute: Neither of its 'name' or 'ref' attributes are set.", pBaseAttribute.getLocator());
            }
            XsESchema schema = pBaseAttribute.getXsESchema();
            this.isGlobal = pBaseAttribute.isGlobal();
            boolean qualified = this.isGlobal;
            if (!qualified) {
                XsFormChoice form = pBaseAttribute.getForm();
                if (form == null) {
                    form = schema.getAttributeFormDefault();
                }
                qualified = XsFormChoice.QUALIFIED.equals(form);
            }
            if (qualified) {
                namespace = schema.getTargetNamespace();
                namespacePrefix = schema.getTargetNamespacePrefix();
            } else {
                namespace = null;
                namespacePrefix = null;
            }
            this.name = new XsQName(namespace, myName.toString(), namespacePrefix);
        }
        this.xsAnnotation = pBaseAttribute.getAnnotation();
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    @Override
    public XsQName getName() {
        return this.name;
    }

    @Override
    public XSType getType() {
        return this.type;
    }

    @Override
    public XSAnnotation[] getAnnotations() {
        return this.annotations;
    }

    protected boolean isValidated() {
        return this.isValidated;
    }

    @Override
    public void validate() throws SAXException {
        XSType myType;
        if (this.isValidated()) {
            return;
        }
        this.isValidated = true;
        if (this.xsAnnotation == null) {
            this.annotations = new XSAnnotation[0];
        } else {
            XSAnnotation ann = this.getXSSchema().getXSObjectFactory().newXSAnnotation(this, this.xsAnnotation);
            this.annotations = new XSAnnotation[]{ann};
            ann.validate();
        }
        if (this.isReference()) {
            XSAttribute attribute = this.getXSSchema().getAttribute(this.getName());
            if (attribute == null) {
                throw new LocSAXException("Invalid attribute reference: No type named " + this.getName() + " defined.", this.getXsTAttribute().getLocator());
            }
            myType = attribute.getType();
        } else if (this.isInnerSimpleType()) {
            XsTLocalSimpleType innerSimpleType = this.getXsTAttribute().getSimpleType();
            myType = this.getXSSchema().getXSObjectFactory().newXSType((XSObject)this, innerSimpleType);
            myType.validate();
        } else {
            XsQName typeName = this.getXsTAttribute().getType();
            if (typeName == null) {
                typeName = XSAnySimpleType.getInstance().getName();
            }
            if ((myType = this.getXSSchema().getType(typeName)) == null) {
                throw new LocSAXException("Invalid attribute: The referenced type " + typeName + " is not defined in the schema.", this.getXsTAttribute().getLocator());
            }
        }
        this.type = myType;
    }

    @Override
    public boolean isOptional() {
        XsTAttribute.Use use = this.getXsTAttribute().getUse();
        if (XsTAttribute.PROHIBITED.equals(use)) {
            throw new IllegalStateException("This attribute is prohibited.");
        }
        return XsTAttribute.OPTIONAL.equals(use);
    }

    @Override
    public String getDefault() {
        return this.getXsTAttribute().getDefault();
    }

    @Override
    public String getFixed() {
        return this.getXsTAttribute().getFixed();
    }
}

