/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.tx;

import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.logging.Logger;
import org.jboss.util.deadlock.ApplicationDeadlockException;

public class TxPolicy {
    protected static final Logger log = Logger.getLogger(TxPolicy.class);
    public static int MAX_RETRIES = 5;
    public static Random random = new Random();

    public void throwMandatory(Invocation invocation) {
        throw new RuntimeException("Transaction is mandatory.");
    }

    public Object invokeInNoTx(Invocation invocation) throws Throwable {
        return invocation.invokeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeInOurTx(Invocation invocation, TransactionManager tm) throws Throwable {
        for (int i = 0; i < MAX_RETRIES; ++i) {
            tm.begin();
            Transaction tx = tm.getTransaction();
            try {
                Object object = invocation.invokeNext();
                this.endTransaction(tm, tx);
                return object;
            }
            catch (Throwable t) {
                try {
                    try {
                        this.handleExceptionInOurTx(invocation, t, tx);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.endTransaction(tm, tx);
                    }
                }
                catch (Exception ex) {
                    ApplicationDeadlockException deadlock = ApplicationDeadlockException.isADE((Throwable)ex);
                    if (deadlock != null) {
                        if (!deadlock.retryable() || i + 1 >= MAX_RETRIES) {
                            throw deadlock;
                        }
                        log.warn((Object)(deadlock.getMessage() + " retrying " + (i + 1)));
                        Thread.sleep(random.nextInt(1 + i), random.nextInt(1000));
                        continue;
                    }
                    throw ex;
                }
            }
        }
        throw new RuntimeException("UNREACHABLE");
    }

    public void handleExceptionInOurTx(Invocation invocation, Throwable t, Transaction tx) throws Throwable {
        this.rethrowApplicationException(invocation, t);
        this.setRollbackOnly(tx);
        throw t;
    }

    public Object invokeInCallerTx(Invocation invocation, Transaction tx) throws Throwable {
        try {
            return invocation.invokeNext();
        }
        catch (Throwable t) {
            this.handleInCallerTx(invocation, t, tx);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    public void handleInCallerTx(Invocation invocation, Throwable t, Transaction tx) throws Throwable {
        this.rethrowApplicationException(invocation, t);
        this.setRollbackOnly(tx);
        throw t;
    }

    public void endTransaction(TransactionManager tm, Transaction tx) {
        try {
            if (tx != tm.getTransaction()) {
                throw new IllegalStateException("Wrong tx on thread: expected " + tx + ", actual " + tm.getTransaction());
            }
            if (tx.getStatus() == 1) {
                tm.rollback();
            } else {
                tm.commit();
            }
        }
        catch (RollbackException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (HeuristicMixedException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (HeuristicRollbackException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (SystemException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
    }

    public void handleEndTransactionException(Exception e) {
        throw new RuntimeException(e);
    }

    public void setRollbackOnly(Transaction tx) {
        try {
            tx.setRollbackOnly();
        }
        catch (SystemException ex) {
            log.error((Object)"SystemException while setting transaction for rollback only", (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            log.error((Object)"IllegalStateException while setting transaction for rollback only", (Throwable)ex);
        }
    }

    public void rethrowApplicationException(Invocation inv, Throwable e) throws Throwable {
        Class[] applicationExceptionsList;
        Object applicationExceptions = inv.getMetaData((Object)"transaction", (Object)"application-exceptions");
        if (applicationExceptions == null) {
            return;
        }
        if (applicationExceptions instanceof String) {
            ArrayList tmpList = new ArrayList();
            String aes = (String)applicationExceptions;
            aes = aes.trim();
            StringTokenizer tokenizer = new StringTokenizer(aes, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                Class<?> excClass = Thread.currentThread().getContextClassLoader().loadClass(token);
                tmpList.add(excClass);
            }
            applicationExceptionsList = tmpList.toArray(new Class[tmpList.size()]);
        } else {
            applicationExceptionsList = (Class[])applicationExceptions;
        }
        for (int i = 0; i < applicationExceptionsList.length; ++i) {
            if (!applicationExceptionsList[i].isInstance(e)) continue;
            throw e;
        }
    }
}

