/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.annotation.MessageProperties;
import org.jboss.ejb3.annotation.Producer;
import org.jboss.ejb3.annotation.Producers;
import org.jboss.ejb3.annotation.impl.ProducerImpl;
import org.jboss.ejb3.mdb.ConsumerContainer;
import org.jboss.ejb3.proxy.JndiSessionProxyObjectFactory;
import org.jboss.ejb3.proxy.ProxyFactory;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

public abstract class ProducerFactory
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(ProducerFactory.class);
    protected Class<?> producer;
    protected MessageProperties props;
    protected Destination dest;
    protected HashMap<?, ?> methodMap;
    protected ProducerImpl pImpl;
    protected String jndiName;
    protected InitialContext ctx;
    protected Hashtable<?, ?> initialContextProperties;
    public static final String PROXY_FACTORY_NAME = "PRODUCER_FACTORY";

    protected ProducerFactory(ConsumerContainer container, Class<?> producer, MessageProperties props, Destination dest, InitialContext ctx, Hashtable<?, ?> ctxProperties) {
        this.producer = producer;
        this.props = props;
        this.dest = dest;
        this.ctx = ctx;
        this.initialContextProperties = ctxProperties;
        this.methodMap = new HashMap();
        Producer p = producer.getAnnotation(Producer.class);
        if (p == null) {
            p = (Producer)container.resolveAnnotation(Producer.class);
        }
        if (p == null) {
            Producers annotation = (Producers)container.resolveAnnotation(Producers.class);
            Producer[] producers = annotation.value();
            for (int i = 0; i < producers.length; ++i) {
                if (producers[i].producer() == null || !producers[i].producer().equals(producer)) continue;
                p = producers[i];
            }
        }
        this.pImpl = new ProducerImpl(p);
        this.jndiName = producer.getName();
    }

    @Override
    public Object createHomeProxy() {
        throw new UnsupportedOperationException("producer can't have a home interface");
    }

    public Object createProxyBusiness(Object id) {
        if (id != null) {
            throw new IllegalArgumentException("producer proxy must not have an id");
        }
        return this.createProxyBusiness();
    }

    public void setContainer(Container container) {
    }

    @Override
    public void start() throws Exception {
        Context baseCtx = this.ctx;
        Name name = baseCtx.getNameParser("").parse(this.jndiName);
        baseCtx = Util.createSubcontext((Context)baseCtx, (Name)name.getPrefix(name.size() - 1));
        String atom = name.get(name.size() - 1);
        StringRefAddr refAddr = new StringRefAddr("FACTORY", atom + PROXY_FACTORY_NAME);
        Reference ref = new Reference("java.lang.Object", refAddr, JndiSessionProxyObjectFactory.class.getName(), null);
        try {
            Util.rebind((Context)baseCtx, (String)atom, (Object)ref);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind producer factory into JNDI under jndiName: " + baseCtx.getNameInNamespace() + "/" + atom);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    @Override
    public void stop() throws Exception {
        Util.unbind((Context)this.ctx, (String)this.jndiName);
    }
}

