/*
 * Copyright 2009 Red Hat, Inc.
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *    http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */

package org.hornetq.core.server.cluster;

import java.util.Map;
import java.util.Set;

import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.core.client.impl.Topology;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.server.HornetQComponent;

/**
 * A ClusterManager
 *
 * @author <a href="mailto:tim.fox@jboss.com">Tim Fox</a>
 * 
 * Created 18 Nov 2008 09:23:26
 *
 */
public interface ClusterManager extends HornetQComponent
{
   Map<String, Bridge> getBridges();

   Set<ClusterConnection> getClusterConnections();

   ClusterConnection getClusterConnection(SimpleString name);

   Set<BroadcastGroup> getBroadcastGroups();

   void addClusterTopologyListener(ClusterTopologyListener listener, boolean clusterConnection);
   
   void removeClusterTopologyListener(ClusterTopologyListener listener, boolean clusterConnection);
   
   void activate();

   void notifyNodeDown(String nodeID);

   void notifyNodeUp(String nodeID, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean backup, boolean nodeAnnounce);

   Topology getTopology();

   void announceBackup() throws Exception;

   void deployBridge(BridgeConfiguration config) throws Exception;

   void destroyBridge(String name) throws Exception;
}
