/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.plugins.jmx;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;

import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperty;

/**
 * Stub class for the MemoryPoolMXBean interface that is marked up with
 * management annotations.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@ManagementObject(
      isRuntime=true,
      componentType=@ManagementComponent(type="MBean", subtype="Platform"),
      targetInterface=MemoryPoolMXBean.class)
public class MemoryPoolMXBeanMO implements MemoryPoolMXBean
{

   @ManagementProperty
   public MemoryUsage getCollectionUsage()
   {
      // TODO Auto-generated method stub
      return null;
   }

   @ManagementProperty
   public long getCollectionUsageThreshold()
   {
      // TODO Auto-generated method stub
      return 0;
   }

   @ManagementProperty
   public long getCollectionUsageThresholdCount()
   {
      // TODO Auto-generated method stub
      return 0;
   }

   @ManagementProperty
   public String[] getMemoryManagerNames()
   {
      // TODO Auto-generated method stub
      return null;
   }

   @ManagementProperty
   @ManagementObjectID(prefix=ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE)
   public String getName()
   {
      // TODO Auto-generated method stub
      return null;
   }

   @ManagementProperty
   public MemoryUsage getPeakUsage()
   {
      return null;
   }

   @ManagementProperty
   public MemoryType getType()
   {
      // TODO Auto-generated method stub
      return null;
   }

   @ManagementProperty
   public MemoryUsage getUsage()
   {
      // TODO Auto-generated method stub
      return null;
   }

   @ManagementProperty
   public long getUsageThreshold()
   {
      // TODO Auto-generated method stub
      return 0;
   }

   @ManagementProperty
   public long getUsageThresholdCount()
   {
      // TODO Auto-generated method stub
      return 0;
   }

   @ManagementProperty
   public boolean isCollectionUsageThresholdExceeded()
   {
      // TODO Auto-generated method stub
      return false;
   }

   @ManagementProperty
   public boolean isCollectionUsageThresholdSupported()
   {
      // TODO Auto-generated method stub
      return false;
   }

   @ManagementProperty
   public boolean isUsageThresholdExceeded()
   {
      // TODO Auto-generated method stub
      return false;
   }

   @ManagementProperty
   public boolean isUsageThresholdSupported()
   {
      // TODO Auto-generated method stub
      return false;
   }

   @ManagementProperty
   public boolean isValid()
   {
      // TODO Auto-generated method stub
      return false;
   }

   @ManagementOperation
   public void resetPeakUsage()
   {
      // TODO Auto-generated method stub

   }

   @ManagementProperty
   public void setCollectionUsageThreshold(long threhsold)
   {
      // TODO Auto-generated method stub

   }

   @ManagementProperty
   public void setUsageThreshold(long threshold)
   {
      // TODO Auto-generated method stub

   }

}
