/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.util.Rsp;

public class RspList
implements Map<Address, Rsp> {
    final Map<Address, Rsp> rsps = new HashMap<Address, Rsp>();

    public RspList() {
    }

    public RspList(Collection<Rsp> responses) {
        if (responses != null) {
            for (Rsp rsp : responses) {
                this.rsps.put(rsp.getSender(), rsp);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.rsps.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.rsps.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rsps.containsValue(value);
    }

    @Override
    public Rsp get(Object key) {
        return this.rsps.get(key);
    }

    public Object getValue(Object key) {
        Rsp rsp = this.get(key);
        return rsp != null ? rsp.getValue() : null;
    }

    @Override
    public Rsp put(Address key, Rsp value) {
        return this.rsps.put(key, value);
    }

    @Override
    public Rsp remove(Object key) {
        return this.rsps.remove(key);
    }

    @Override
    public void putAll(Map<? extends Address, ? extends Rsp> m) {
        this.rsps.putAll(m);
    }

    @Override
    public void clear() {
        this.rsps.clear();
    }

    @Override
    public Set<Address> keySet() {
        return this.rsps.keySet();
    }

    @Override
    public Collection<Rsp> values() {
        return this.rsps.values();
    }

    @Override
    public Set<Map.Entry<Address, Rsp>> entrySet() {
        return this.rsps.entrySet();
    }

    public void reset() {
        this.clear();
    }

    public void addRsp(Address sender, Object retval) {
        Rsp rsp = this.get(sender);
        if (rsp != null) {
            rsp.sender = sender;
            rsp.retval = retval;
            rsp.received = true;
            rsp.suspected = false;
            return;
        }
        this.rsps.put(sender, new Rsp(sender, retval));
    }

    public void addNotReceived(Address sender) {
        Rsp rsp = this.get(sender);
        if (rsp == null) {
            this.rsps.put(sender, new Rsp(sender));
        }
    }

    public void addSuspect(Address sender) {
        Rsp rsp = this.get(sender);
        if (rsp != null) {
            rsp.sender = sender;
            rsp.retval = null;
            rsp.received = false;
            rsp.suspected = true;
            return;
        }
        this.rsps.put(sender, new Rsp(sender, true));
    }

    public boolean isReceived(Address sender) {
        Rsp rsp = this.get(sender);
        return rsp != null && rsp.received;
    }

    public int numSuspectedMembers() {
        int num = 0;
        Collection<Rsp> values = this.values();
        for (Rsp rsp : values) {
            if (!rsp.wasSuspected()) continue;
            ++num;
        }
        return num;
    }

    public int numReceived() {
        int num = 0;
        Collection<Rsp> values = this.values();
        for (Rsp rsp : values) {
            if (!rsp.wasReceived()) continue;
            ++num;
        }
        return num;
    }

    public Object getFirst() {
        Collection<Rsp> values = this.values();
        for (Rsp rsp : values) {
            if (rsp.getValue() == null) continue;
            return rsp.getValue();
        }
        return null;
    }

    public Vector<Object> getResults() {
        Vector<Object> ret = new Vector<Object>();
        for (Rsp rsp : this.values()) {
            Object val;
            if (!rsp.wasReceived() || (val = rsp.getValue()) == null) continue;
            ret.addElement(val);
        }
        return ret;
    }

    public Vector<Address> getSuspectedMembers() {
        Vector<Address> retval = new Vector<Address>();
        for (Rsp rsp : this.values()) {
            if (!rsp.wasSuspected()) continue;
            retval.addElement(rsp.getSender());
        }
        return retval;
    }

    public boolean isSuspected(Address sender) {
        Rsp rsp = this.get(sender);
        return rsp != null && rsp.suspected;
    }

    @Override
    public int size() {
        return this.rsps.size();
    }

    public Object elementAt(int i) throws ArrayIndexOutOfBoundsException {
        TreeSet<Address> keys = new TreeSet<Address>(this.keySet());
        Object[] keys_array = keys.toArray();
        Object key = keys_array[i];
        return this.get(key);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (Rsp rsp : this.values()) {
            ret.append("[" + rsp + "]\n");
        }
        return ret.toString();
    }

    boolean contains(Address sender) {
        return this.containsKey(sender);
    }
}

