/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.impl.jndiregistrar;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ejb3.proxy.impl.jndiregistrar.JndiReferenceBinding;

public class JndiReferenceBindingSet {
    private Context context;
    private final Hashtable<?, ?> namingEnvironment;
    private Set<JndiReferenceBinding> homeRemoteBindings = new HashSet<JndiReferenceBinding>();
    private Set<JndiReferenceBinding> defaultRemoteBindings = new HashSet<JndiReferenceBinding>();
    private Map<String, Set<JndiReferenceBinding>> businessRemoteBindings = new HashMap<String, Set<JndiReferenceBinding>>();
    private Set<JndiReferenceBinding> homeLocalBindings = new HashSet<JndiReferenceBinding>();
    private Set<JndiReferenceBinding> defaultLocalBindings = new HashSet<JndiReferenceBinding>();
    private Map<String, Set<JndiReferenceBinding>> businessLocalBindings = new HashMap<String, Set<JndiReferenceBinding>>();

    public JndiReferenceBindingSet(Context context) {
        assert (context != null) : "context is null";
        this.context = context;
        try {
            this.namingEnvironment = context.getEnvironment();
        }
        catch (NamingException e) {
            throw new RuntimeException("Cannot retrieve naming environment from " + context);
        }
    }

    public Context getContext() {
        try {
            this.context.getEnvironment();
        }
        catch (NamingException ne) {
            try {
                this.context = new InitialContext(this.namingEnvironment);
            }
            catch (NamingException e) {
                throw new RuntimeException("Cannot create InitialContext from " + this.namingEnvironment);
            }
        }
        return this.context;
    }

    public Set<JndiReferenceBinding> getHomeRemoteBindings() {
        return new HashSet<JndiReferenceBinding>(this.homeRemoteBindings);
    }

    public void addHomeRemoteBinding(JndiReferenceBinding binding) {
        assert (binding != null) : "binding is null";
        this.homeRemoteBindings.add(binding);
    }

    public Set<JndiReferenceBinding> getDefaultRemoteBindings() {
        return new HashSet<JndiReferenceBinding>(this.defaultRemoteBindings);
    }

    public void addDefaultRemoteBinding(JndiReferenceBinding binding) {
        assert (binding != null) : "binding is null";
        this.defaultRemoteBindings.add(binding);
    }

    public Map<String, Set<JndiReferenceBinding>> getBusinessRemoteBindings() {
        return new HashMap<String, Set<JndiReferenceBinding>>(this.businessRemoteBindings);
    }

    public void addBusinessRemoteBinding(String businessInterfaceName, JndiReferenceBinding binding) {
        assert (businessInterfaceName != null) : "businessInterfaceName is null";
        assert (binding != null) : "binding is null";
        Set<JndiReferenceBinding> bindings = this.businessRemoteBindings.get(businessInterfaceName);
        if (bindings == null) {
            bindings = new HashSet<JndiReferenceBinding>();
            this.businessRemoteBindings.put(businessInterfaceName, bindings);
        }
        bindings.add(binding);
    }

    public Set<JndiReferenceBinding> getHomeLocalBindings() {
        return new HashSet<JndiReferenceBinding>(this.homeLocalBindings);
    }

    public void addHomeLocalBinding(JndiReferenceBinding binding) {
        assert (binding != null) : "binding is null";
        this.homeLocalBindings.add(binding);
    }

    public Set<JndiReferenceBinding> getDefaultLocalBindings() {
        return new HashSet<JndiReferenceBinding>(this.defaultLocalBindings);
    }

    public void addDefaultLocalBinding(JndiReferenceBinding binding) {
        assert (binding != null) : "binding is null";
        this.defaultLocalBindings.add(binding);
    }

    public Map<String, Set<JndiReferenceBinding>> getBusinessLocalBindings() {
        return new HashMap<String, Set<JndiReferenceBinding>>(this.businessLocalBindings);
    }

    public void addBusinessLocalBinding(String businessInterfaceName, JndiReferenceBinding binding) {
        assert (businessInterfaceName != null) : "businessInterfaceName is null";
        assert (binding != null) : "binding is null";
        Set<JndiReferenceBinding> bindings = this.businessLocalBindings.get(businessInterfaceName);
        if (bindings == null) {
            bindings = new HashSet<JndiReferenceBinding>();
            this.businessLocalBindings.put(businessInterfaceName, bindings);
        }
        bindings.add(binding);
    }
}

