/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.impl.CachedType;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.memory.FieldPersistentReference;

public final class ObjectUtil {
    private static final Log log = LogFactory.getLog((String)ObjectUtil.class.getName());

    public static boolean isReachable(PojoCacheImpl cache, Object originalObject, Object thisObject) throws CacheException {
        HashSet objSet = new HashSet();
        return ObjectUtil.isReachableInner(cache, originalObject, thisObject, objSet);
    }

    private static boolean isReachableInner(PojoCacheImpl cache, Object originalObject, Object thisObject, Set objSet) throws CacheException {
        if (!(originalObject instanceof Advised)) {
            throw new PojoCacheException("ObjectUtil.isReachable(): originalObject is not Advised.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("isReachable(): current object: " + originalObject + " this object: " + thisObject));
        }
        if (originalObject.equals(thisObject)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"isReachable(): object found reachable.");
            }
            return true;
        }
        if (objSet.contains(originalObject)) {
            return false;
        }
        objSet.add(originalObject);
        CachedType type = cache.getCachedType(originalObject.getClass());
        Iterator<FieldPersistentReference> i = type.getFields().iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next().get();
            Object value = null;
            try {
                value = field.get(originalObject);
            }
            catch (IllegalAccessException e) {
                throw new CacheException("field access failed", (Throwable)e);
            }
            CachedType fieldType = cache.getCachedType(field.getType());
            if (fieldType.isImmediate()) continue;
            if (value instanceof Map) {
                Set set = ((Map)value).keySet();
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    if (!ObjectUtil.isReachableInner(cache, it.next(), thisObject, objSet)) continue;
                    return true;
                }
                continue;
            }
            if (value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                while (it.hasNext()) {
                    if (!ObjectUtil.isReachableInner(cache, it.next(), thisObject, objSet)) continue;
                    return true;
                }
                continue;
            }
            if (!(value instanceof Advised) || !ObjectUtil.isReachableInner(cache, value, thisObject, objSet)) continue;
            return true;
        }
        return false;
    }

    public static String getIndirectFqn(Fqn fqn) {
        return ObjectUtil.getIndirectFqn(fqn.toString());
    }

    public static String getIndirectFqn(String fqn) {
        return fqn.replace('/', '_');
    }

    public static String identityString(Object object) {
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }
}

