/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.PropagationType;
import org.jboss.seam.faces.FacesPage;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.ConversationIdParameter;
import org.jboss.seam.navigation.Page;
import org.jboss.seam.navigation.Pages;

@Name(value="org.jboss.seam.core.conversationPropagation")
@Scope(value=ScopeType.EVENT)
@BypassInterceptors
@Install(precedence=0)
public class ConversationPropagation {
    private static final LogProvider log = Logging.getLogProvider(ConversationPropagation.class);
    public static final String CONVERSATION_NAME_PARAMETER = "conversationName";
    public static final String CONVERSATION_PROPAGATION_PARAMETER = "conversationPropagation";
    private String conversationName;
    private String conversationId;
    private String parentConversationId;
    private boolean validateLongRunningConversation;
    private PropagationType propagationType;
    private String pageflow;

    public void restoreConversationId(Map parameters) {
        this.restoreNaturalConversationId(parameters);
        this.restoreSyntheticConversationId(parameters);
        this.restorePageContextConversationId();
        this.getPropagationFromRequestParameter(parameters);
        this.handlePropagationType(parameters);
    }

    private void handlePropagationType(Map parameters) {
        if (this.propagationType == PropagationType.NONE) {
            this.conversationId = null;
            this.parentConversationId = null;
            this.validateLongRunningConversation = false;
        } else if (this.propagationType == PropagationType.END) {
            this.validateLongRunningConversation = false;
        }
    }

    private void restorePageContextConversationId() {
        if (Contexts.isPageContextActive() && ConversationPropagation.isMissing(this.conversationId)) {
            FacesPage page = FacesPage.instance();
            this.conversationId = page.getConversationId();
            this.parentConversationId = null;
            this.validateLongRunningConversation = page.isConversationLongRunning();
        } else {
            log.trace("Found conversation id in request parameter: " + this.conversationId);
        }
    }

    private void restoreNaturalConversationId(Map parameters) {
        this.conversationName = ConversationPropagation.getRequestParameterValue(parameters, CONVERSATION_NAME_PARAMETER);
        if (this.conversationName != null && this.conversationName.contains(":")) {
            int idx = this.conversationName.indexOf(58);
            this.conversationId = this.conversationName;
            this.conversationName = this.conversationName.substring(0, idx);
            return;
        }
        String viewId = Pages.getCurrentViewId();
        if (viewId != null) {
            Page page = Pages.instance().getPage(viewId);
            if (this.conversationName != null) {
                ConversationIdParameter currentConversationIdParameter = Pages.instance().getConversationIdParameter(this.conversationName);
                if (currentConversationIdParameter == null) {
                    throw new IllegalStateException("The conversationName specified: " + this.conversationName + ", does not exist.");
                }
                this.conversationId = currentConversationIdParameter.getRequestConversationId(parameters);
            } else {
                this.conversationId = page.getConversationIdParameter().getRequestConversationId(parameters);
            }
        }
    }

    private void restoreSyntheticConversationId(Map parameters) {
        Manager manager = Manager.instance();
        if (ConversationPropagation.isMissing(this.conversationId)) {
            this.conversationId = ConversationPropagation.getRequestParameterValue(parameters, manager.getConversationIdParameter());
        }
        if (ConversationPropagation.isMissing(this.parentConversationId)) {
            this.parentConversationId = ConversationPropagation.getRequestParameterValue(parameters, manager.getParentConversationIdParameter());
        }
    }

    private void getPropagationFromRequestParameter(Map parameters) {
        String value = ConversationPropagation.getRequestParameterValue(parameters, CONVERSATION_PROPAGATION_PARAMETER);
        if (value == null) {
            return;
        }
        if (value.startsWith("begin")) {
            this.propagationType = PropagationType.BEGIN;
            if (value.length() > 6) {
                this.pageflow = value.substring(6);
            }
        } else if (value.startsWith("join")) {
            this.propagationType = PropagationType.JOIN;
            if (value.length() > 5) {
                this.pageflow = value.substring(5);
            }
        } else if (value.startsWith("nest")) {
            this.propagationType = PropagationType.NEST;
            if (value.length() > 5) {
                this.pageflow = value.substring(5);
            }
        } else {
            this.propagationType = PropagationType.valueOf(value.toUpperCase());
        }
    }

    private static boolean isMissing(String storedConversationId) {
        return storedConversationId == null || "".equals(storedConversationId);
    }

    public static String getRequestParameterValue(Map parameters, String parameterName) {
        Object object = parameters.get(parameterName);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        String[] values = (String[])object;
        if (values.length != 1) {
            throw new IllegalArgumentException("expected exactly one value for " + parameterName + " request parameter");
        }
        return values[0];
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getParentConversationId() {
        return this.parentConversationId;
    }

    public void setParentConversationId(String parentConversationId) {
        this.parentConversationId = parentConversationId;
    }

    public boolean isValidateLongRunningConversation() {
        return this.validateLongRunningConversation;
    }

    public void setValidateLongRunningConversation(boolean validateLongRunningConversation) {
        this.validateLongRunningConversation = validateLongRunningConversation;
    }

    public static ConversationPropagation instance() {
        if (!Contexts.isEventContextActive()) {
            throw new IllegalStateException("No active event context");
        }
        return (ConversationPropagation)Component.getInstance(ConversationPropagation.class, ScopeType.EVENT);
    }

    public PropagationType getPropagationType() {
        return this.propagationType;
    }

    public void setPropagationType(PropagationType propagationType) {
        this.propagationType = propagationType;
    }

    public String getPageflow() {
        return this.pageflow;
    }

    public String getConversationName() {
        return this.conversationName;
    }
}

