/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.stream;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.management.MBeanServer;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.stream.StreamInvocationHandler;
import org.jboss.remoting.transport.Connector;

public class StreamingServer {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;
    private String locatorURI = transport + "://" + host + ":" + port;
    private Connector connector = null;

    public void setupServer() throws Exception {
        InvokerLocator locator = new InvokerLocator(this.locatorURI);
        System.out.println("Starting remoting server with locator uri of: " + this.locatorURI);
        this.connector = new Connector();
        this.connector.setInvokerLocator(locator.getLocatorURI());
        this.connector.create();
        TestStreamInvocationHandler invocationHandler = new TestStreamInvocationHandler();
        this.connector.addInvocationHandler("test_stream", invocationHandler);
        this.connector.start(true);
    }

    public static void main(String[] args) {
        if (args != null && args.length == 3) {
            transport = args[0];
            host = args[1];
            port = Integer.parseInt(args[2]);
        }
        StreamingServer server = new StreamingServer();
        try {
            server.setupServer();
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static class TestStreamInvocationHandler
    implements StreamInvocationHandler {
        private long streamSize = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object handleStream(InputStream stream, InvocationRequest param) {
            try {
                int c;
                String fileName = (String)param.getParameter();
                System.out.println("Received input stream from client to write out to file " + fileName);
                File newFile = new File(fileName);
                if (!newFile.exists()) {
                    newFile.createNewFile();
                }
                FileOutputStream out = new FileOutputStream(newFile, false);
                byte[] buf = new byte[4096];
                while ((c = stream.read(buf)) >= 0) {
                    out.write(buf, 0, c);
                }
                out.flush();
                out.close();
                this.streamSize = newFile.length();
                System.out.println("New file " + fileName + " has been written out to " + newFile.getAbsolutePath());
                System.out.println("Size of " + newFile.getAbsolutePath() + " is " + this.streamSize);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return new Long(this.streamSize);
        }

        @Override
        public Object invoke(InvocationRequest invocation) throws Throwable {
            System.out.println("Invocation request is: " + invocation.getParameter());
            return new Long(this.streamSize);
        }

        @Override
        public void addListener(InvokerCallbackHandler callbackHandler) {
        }

        @Override
        public void removeListener(InvokerCallbackHandler callbackHandler) {
        }

        @Override
        public void setMBeanServer(MBeanServer server) {
        }

        @Override
        public void setInvoker(ServerInvoker invoker) {
        }
    }
}

