#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#
# Common post build package stage
# $1    package directory
# $2    destination directory
# $3    program base
# $@

# Include common code
. "$XB_BUILD_DIR/xb.functions.sh"

postbld_exit_code=0
xb_postbld()
{
    pd="$1"
    dd="$2"
    pb="$3"
    shift; shift; shift
    if [ ".$1" != . ]; then
        pp=true
    else
        pp=false
    fi
    if [ ! -f "$pd/package.list" ]; then
        return 22
    fi
    if [ ! -d "$dd" ]; then
        return 22
    fi
    if [ -d "$XB_BUILD_ROOT$o_prefix" ]; then
    (
        cd "$XB_BUILD_ROOT$o_prefix"
        rm -rf share >/dev/null 2>&1 || true

        if [ -d "include/httpd" ]; then
            (
                cd include/httpd
                rm -f htt*.h >/dev/null 2>&1 || true
                rm -f mod*.h >/dev/null 2>&1 || true
                rm -f mpm*.h >/dev/null 2>&1 || true
                rm -f ap_*.h >/dev/null 2>&1 || true
                rm -f sco*.h >/dev/null 2>&1 || true
                rm -f uti*.h >/dev/null 2>&1 || true
                rm -f uni*.h >/dev/null 2>&1 || true
                rm -f os.h >/dev/null 2>&1 || true
                cd ..
                rm -rf apr-1 >/dev/null 2>&1 || true
                mv httpd apr-1 >/dev/null 2>&1 || true
            )
        fi
        if [ -d "$libd" ]; then
            (
                cd $libd
                rm -f libh*.* >/dev/null 2>&1 || true
                rm -f mod_*.* >/dev/null 2>&1 || true
            )
        fi
        if [ -h lib ]; then
            rm -f lib 2>&1 || true
        fi
        rm -rf var 2>&1 || true
        if [ ".$XB_BUILD_SYS" = ".windows" ]; then
            if [ -d etc ]; then
                chmod 775 bin/*.bat >/dev/null 2>&1 || true
                chmod 775 bin/*.exe >/dev/null 2>&1 || true
            fi
            if [ -d sbin ]; then
                chmod 775 sbin/*.bat >/dev/null 2>&1 || true
                chmod 775 sbin/*.exe >/dev/null 2>&1 || true
                chmod 775 sbin/*.dll >/dev/null 2>&1 || true
            fi
        fi
    )
    fi

    return $postbld_exit_code
}

xb_postbld $@
exit $?

