#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#
# Run package patch cleanup
# $1    package directory
# $2    destination directory
# $@

# Include common code
. "$XB_BUILD_DIR/xb.functions.sh"

buildpatch_exit_code=0
xb_buildpatch()
{
    rmas=true
    pd="$1"
    dd="$2"
    if [ ! -f "$pd/package.pbld" ]; then
        return 22
    fi
    # Create working base directories
    install -m 755 -d "$XB_BUILD_TDIR$XB_PACKAGE_BASE"
    cd "$XB_BUILD_ROOT$XB_PACKAGE_BASE"

    sIFS=$IFS; IFS=$XB_LF
    lines=`$XB_GSED -e 's/^[[:blank:]]*//' \
                -e '/^[[:blank:]]*$/d' \
                -e '/^[#;].*/d' "$pd/package.pbld"`
    for l in $lines
    do
        IFS=$sIFS
        r=`echo $l | awk '{print $1}'`
        n=`echo $l | awk '{print $2}'`
        eval "p=$n"
        case "$r" in
            S )
                rmas=false
            ;;
            C )
                xbcopypdir "$p" "$XB_BUILD_TDIR$XB_PACKAGE_BASE/$p"
            ;;
            + )
                x=`echo $p | awk '{print $1}'`
                d=`dirname $x`
                if [ ".$d" = ".." ]; then
                    d=""
                else
                    d="$d/"
                fi
                hasfiles=false;
                for i in $p
                do
                    if [ ! -h $i ]; then
                        if [ -f $i ]; then
                            hasfiles=true;
                            break;
                        fi
                    fi
                done
                if $hasfiles ; then
                    install -m 755 -d "$XB_BUILD_TDIR$XB_PACKAGE_BASE/$d"
                    for i in $p
                    do
                        if [ -h $i ]; then
                            $XB_VERBOSE "Skipping symlink \`$i'"
                        else
                            cp -p $i "$XB_BUILD_TDIR$XB_PACKAGE_BASE/$d" >/dev/null 2>&1 || true
                        fi
                    done
                fi
            ;;
            - )
                rm -rf $XB_BUILD_TDIR$XB_PACKAGE_BASE/$p >/dev/null 2>&1 || true
            ;;
        esac
    done
    # Remove all symbolic links
    if $rmas ; then
        sIFS=$IFS; IFS=$XB_LF
        for i in `find "$XB_BUILD_TDIR$XB_PACKAGE_BASE" -print`
        do
           IFS=$sIFS
           if [ -h "$i" ]; then
               rm -f "$i" >/dev/null 2>&1 || true
           fi
        done
    fi
    return $buildpatch_exit_code
}

xb_buildpatch $@
exit $?
