/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.TubelineAssembler;
import com.sun.xml.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.EndpointAwareCodec;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.model.wsdl.WSDLProperties;
import com.sun.xml.ws.resources.HandlerMessages;
import com.sun.xml.ws.server.InvokerTube;
import com.sun.xml.ws.server.JMXAgent;
import com.sun.xml.ws.server.ServiceDefinitionImpl;
import com.sun.xml.ws.util.Pool;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.handler.Handler;
import org.w3c.dom.Element;

public final class WSEndpointImpl<T>
extends WSEndpoint<T> {
    @NotNull
    private final QName serviceName;
    @NotNull
    private final QName portName;
    private final WSBinding binding;
    private final SEIModel seiModel;
    @NotNull
    private final Container container;
    private final WSDLPort port;
    private final Tube masterTubeline;
    private final ServiceDefinitionImpl serviceDef;
    private final SOAPVersion soapVersion;
    private final Engine engine;
    @NotNull
    private final Codec masterCodec;
    private final Pool<Tube> tubePool;
    private boolean disposed;
    private final Class<T> implementationClass;
    @Nullable
    private final WSDLProperties wsdlProperties;
    private final Set<EndpointComponent> componentRegistry = new LinkedHashSet<EndpointComponent>();
    private static final Logger logger;

    WSEndpointImpl(@NotNull QName serviceName, @NotNull QName portName, WSBinding binding, Container container, SEIModel seiModel, WSDLPort port, Class<T> implementationClass, @Nullable ServiceDefinitionImpl serviceDef, InvokerTube terminalTube, boolean isSynchronous) {
        this.serviceName = serviceName;
        this.portName = portName;
        this.binding = binding;
        this.soapVersion = binding.getSOAPVersion();
        this.container = container;
        this.port = port;
        this.implementationClass = implementationClass;
        this.serviceDef = serviceDef;
        this.seiModel = seiModel;
        if (serviceDef != null) {
            serviceDef.setOwner(this);
        }
        TubelineAssembler assembler = TubelineAssemblerFactory.create(Thread.currentThread().getContextClassLoader(), binding.getBindingId(), container);
        assert (assembler != null);
        ServerPipeAssemblerContext context = new ServerPipeAssemblerContext(seiModel, port, this, terminalTube, isSynchronous);
        this.masterTubeline = assembler.createServer(context);
        Codec c = context.getCodec();
        if (c instanceof EndpointAwareCodec) {
            c = c.copy();
            ((EndpointAwareCodec)c).setEndpoint(this);
        }
        this.masterCodec = c;
        this.tubePool = new Pool.TubePool(this.masterTubeline);
        terminalTube.setEndpoint(this);
        this.engine = new Engine(this.toString());
        this.wsdlProperties = port == null ? null : new WSDLProperties(port);
    }

    @Override
    @NotNull
    public Class<T> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    @NotNull
    public WSBinding getBinding() {
        return this.binding;
    }

    @Override
    @NotNull
    public Container getContainer() {
        return this.container;
    }

    @Override
    public WSDLPort getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public SEIModel getSEIModel() {
        return this.seiModel;
    }

    @Override
    public void setExecutor(Executor exec) {
        this.engine.setExecutor(exec);
    }

    @Override
    public void schedule(final Packet request, final WSEndpoint.CompletionCallback callback, FiberContextSwitchInterceptor interceptor) {
        request.endpoint = this;
        if (this.wsdlProperties != null) {
            request.addSatellite(this.wsdlProperties);
        }
        Fiber fiber = this.engine.createFiber();
        if (interceptor != null) {
            fiber.addInterceptor(interceptor);
        }
        final Tube tube = this.tubePool.take();
        fiber.start(tube, request, new Fiber.CompletionCallback(){

            @Override
            public void onCompletion(@NotNull Packet response) {
                WSEndpointImpl.this.tubePool.recycle(tube);
                if (callback != null) {
                    callback.onCompletion(response);
                }
            }

            @Override
            public void onCompletion(@NotNull Throwable error) {
                error.printStackTrace();
                Message faultMsg = SOAPFaultBuilder.createSOAPFaultMessage(WSEndpointImpl.this.soapVersion, null, error);
                Packet response = request.createServerResponse(faultMsg, request.endpoint.getPort(), null, request.endpoint.getBinding());
                if (callback != null) {
                    callback.onCompletion(response);
                }
            }
        });
    }

    @Override
    @NotNull
    public WSEndpoint.PipeHead createPipeHead() {
        return new WSEndpoint.PipeHead(){
            private final Tube tube;
            {
                this.tube = TubeCloner.clone(WSEndpointImpl.this.masterTubeline);
            }

            @Override
            @NotNull
            public Packet process(Packet request, WebServiceContextDelegate wscd, TransportBackChannel tbc) {
                Packet response;
                request.webServiceContextDelegate = wscd;
                request.transportBackChannel = tbc;
                request.endpoint = WSEndpointImpl.this;
                if (WSEndpointImpl.this.wsdlProperties != null) {
                    request.addSatellite(WSEndpointImpl.this.wsdlProperties);
                }
                Fiber fiber = WSEndpointImpl.this.engine.createFiber();
                try {
                    response = fiber.runSync(this.tube, request);
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                    Message faultMsg = SOAPFaultBuilder.createSOAPFaultMessage(WSEndpointImpl.this.soapVersion, null, re);
                    response = request.createServerResponse(faultMsg, request.endpoint.getPort(), null, request.endpoint.getBinding());
                }
                return response;
            }
        };
    }

    @Override
    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.masterTubeline.preDestroy();
        block2: for (Handler handler : this.binding.getHandlerChain()) {
            for (Method method : handler.getClass().getMethods()) {
                if (method.getAnnotation(PreDestroy.class) == null) continue;
                try {
                    method.invoke((Object)handler, new Object[0]);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, HandlerMessages.HANDLER_PREDESTROY_IGNORE(e.getMessage()), e);
                }
                continue block2;
            }
        }
    }

    @Override
    public ServiceDefinitionImpl getServiceDefinition() {
        return this.serviceDef;
    }

    @Override
    public Set<EndpointComponent> getComponentRegistry() {
        return this.componentRegistry;
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String address, String wsdlAddress, Element ... referenceParameters) {
        AddressingVersion av;
        QName portType = null;
        if (this.port != null) {
            portType = this.port.getBinding().getPortTypeName();
        }
        List<Element> refParams = null;
        if (referenceParameters != null) {
            refParams = Arrays.asList(referenceParameters);
        }
        if ((av = AddressingVersion.fromSpecClass(clazz)) == AddressingVersion.W3C) {
            return new WSEndpointReference(AddressingVersion.W3C, address, null, null, null, null, null, refParams).toSpec(clazz);
        }
        return new WSEndpointReference(AddressingVersion.MEMBER, address, this.serviceName, this.portName, portType, null, wsdlAddress, refParams).toSpec(clazz);
    }

    @Override
    @NotNull
    public QName getPortName() {
        return this.portName;
    }

    @Override
    @NotNull
    public Codec createCodec() {
        return this.masterCodec.copy();
    }

    @Override
    @NotNull
    public QName getServiceName() {
        return this.serviceName;
    }

    static {
        try {
            JMXAgent.getDefault();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.endpoint");
    }
}

