/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.common.beans.property.PropertyEditorSupport;
import org.jboss.common.beans.property.finder.PropertyEditorFinder;
import org.jboss.common.beans.property.token.ArrayTokenizer;
import org.jboss.common.beans.property.token.StrictTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericArrayPropertyEditor<T>
extends PropertyEditorSupport<T> {
    private static final Logger logger = Logger.getLogger(GenericArrayPropertyEditor.class.getName());
    private final Class<?> cellType;

    public GenericArrayPropertyEditor(Class<T> initType) {
        super(initType);
        if (!initType.isArray()) {
            throw new IllegalArgumentException("Type is not array! " + initType);
        }
        this.cellType = initType.getComponentType();
        PropertyEditor cellPropertyEditor = PropertyEditorFinder.getInstance().find(this.cellType);
        if (cellPropertyEditor == null) {
            throw new IllegalArgumentException("No editor found for '" + this.cellType + "'");
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (BeanUtils.isNull(text)) {
            this.setValue(null);
            return;
        }
        PropertyEditor cellPropertyEditor = PropertyEditorFinder.getInstance().find(this.cellType);
        String[] cellStringValues = this.tokenize(text);
        Object reflectiveArray = Array.newInstance(this.cellType, cellStringValues.length);
        for (int index = 0; index < cellStringValues.length; ++index) {
            cellPropertyEditor.setAsText(cellStringValues[index]);
            Object cellValue = cellPropertyEditor.getValue();
            Array.set(reflectiveArray, index, cellValue);
        }
        this.setValue(reflectiveArray);
    }

    @Override
    public String getAsText() {
        Object reflectiveArray = this.getValue();
        if (reflectiveArray == null) {
            return null;
        }
        PropertyEditor cellPropertyEditor = PropertyEditorFinder.getInstance().find(this.cellType);
        int length = Array.getLength(reflectiveArray);
        String[] cellStringValues = new String[length];
        for (int index = 0; index < length; ++index) {
            Object cellValue = Array.get(reflectiveArray, index);
            cellPropertyEditor.setValue(cellValue);
            cellStringValues[index] = cellPropertyEditor.getAsText();
        }
        return this.encode(cellStringValues);
    }

    protected String[] tokenize(String text) {
        ArrayTokenizer arrayTokenizer = this.getTokenizer();
        return arrayTokenizer.tokenize(text);
    }

    protected String encode(String[] v) {
        StringBuffer text = new StringBuffer();
        for (int index = 0; index < v.length; ++index) {
            if (index > 0) {
                text.append(',');
            }
            text.append(v[index]);
        }
        return text.toString();
    }

    protected Class<?> getCellType() {
        return this.cellType;
    }

    protected ArrayTokenizer getTokenizer() {
        block3: {
            try {
                ServiceLoader<ArrayTokenizer> service = ServiceLoader.load(ArrayTokenizer.class);
                Iterator<ArrayTokenizer> it = service.iterator();
                if (it.hasNext()) {
                    return it.next();
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINEST)) break block3;
                logger.log(Level.FINEST, "Failed to load tokenizer via ServiceLoader, falling back to '" + StrictTokenizer.class.getName() + "'.", e);
            }
        }
        return new StrictTokenizer();
    }
}

