/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.javascript;

import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.faces.FacesException;
import org.ajax4jsf.Messages;
import org.ajax4jsf.javascript.JSEncoder;
import org.ajax4jsf.javascript.ScriptString;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptUtils {
    private static final Log LOG = LogFactory.getLog(ScriptUtils.class);

    private ScriptUtils() {
    }

    public static String toScript(Object obj) {
        IdentityHashMap<Object, Boolean> cycleBusterMap = new IdentityHashMap<Object, Boolean>();
        return ScriptUtils.toScript(obj, cycleBusterMap);
    }

    private static String toScript(Object obj, Map<Object, Boolean> cycleBusterMap) {
        String result;
        Boolean cycleBusterValue = cycleBusterMap.put(obj, Boolean.TRUE);
        if (cycleBusterValue != null) {
            if (LOG.isDebugEnabled()) {
                String formattedMessage;
                try {
                    formattedMessage = Messages.getMessage("JAVASCRIPT_CIRCULAR_REFERENCE", obj);
                }
                catch (MissingResourceException e) {
                    formattedMessage = MessageFormat.format("Circular reference serializing object to JS: {0}", obj);
                }
                LOG.debug((Object)formattedMessage);
            }
            result = "null";
        } else if (null == obj) {
            result = "null";
        } else if (obj instanceof ScriptString) {
            result = ((ScriptString)obj).toScript();
        } else if (obj.getClass().isArray()) {
            StringBuilder ret = new StringBuilder("[");
            boolean first = true;
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Object element = Array.get(obj, i);
                if (!first) {
                    ret.append(',');
                }
                ret.append(ScriptUtils.toScript(element, cycleBusterMap));
                first = false;
            }
            result = ret.append("] ").toString();
        } else if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            StringBuilder ret = new StringBuilder("[");
            boolean first = true;
            for (Object element : collection) {
                if (!first) {
                    ret.append(',');
                }
                ret.append(ScriptUtils.toScript(element, cycleBusterMap));
                first = false;
            }
            result = ret.append("] ").toString();
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            StringBuilder ret = new StringBuilder("{");
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (!first) {
                    ret.append(',');
                }
                ScriptUtils.addEncodedString(ret, entry.getKey());
                ret.append(":");
                ret.append(ScriptUtils.toScript(entry.getValue(), cycleBusterMap));
                first = false;
            }
            result = ret.append("} ").toString();
        } else if (obj instanceof Number || obj instanceof Boolean) {
            result = obj.toString();
        } else if (obj instanceof String) {
            StringBuilder ret = new StringBuilder();
            ScriptUtils.addEncodedString(ret, obj);
            result = ret.toString();
        } else if (obj instanceof Enum) {
            StringBuilder ret = new StringBuilder();
            ScriptUtils.addEncodedString(ret, obj);
            result = ret.toString();
        } else if (obj.getClass().getName().startsWith("java.sql.")) {
            StringBuilder ret = new StringBuilder("{");
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : PropertyUtils.getPropertyDescriptors((Object)obj)) {
                String key = propertyDescriptor.getName();
                if ("class".equals(key)) continue;
                Object value = null;
                try {
                    value = PropertyUtils.getProperty((Object)obj, (String)key);
                }
                catch (Exception e) {
                    continue;
                }
                if (!first) {
                    ret.append(',');
                }
                ScriptUtils.addEncodedString(ret, key);
                ret.append(":");
                ret.append(ScriptUtils.toScript(value, cycleBusterMap));
                first = false;
            }
            result = ret.append("} ").toString();
        } else {
            try {
                StringBuilder ret = new StringBuilder("{");
                PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)obj);
                boolean first = true;
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    String key = propertyDescriptor.getName();
                    if ("class".equals(key)) continue;
                    if (!first) {
                        ret.append(',');
                    }
                    ScriptUtils.addEncodedString(ret, key);
                    ret.append(":");
                    ret.append(ScriptUtils.toScript(PropertyUtils.getProperty((Object)obj, (String)key), cycleBusterMap));
                    first = false;
                }
                result = ret.append("} ").toString();
            }
            catch (Exception e) {
                throw new FacesException("Error in conversion Java Object to JavaScript", (Throwable)e);
            }
        }
        if (cycleBusterValue == null) {
            cycleBusterMap.remove(obj);
        }
        return result;
    }

    public static void addEncodedString(StringBuilder buff, Object obj) {
        buff.append("'");
        ScriptUtils.addEncoded(buff, obj);
        buff.append("'");
    }

    public static void addEncoded(StringBuilder buff, Object obj) {
        JSEncoder encoder = new JSEncoder();
        char[] chars = obj.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!encoder.compile(c)) {
                buff.append(encoder.encode(c));
                continue;
            }
            buff.append(c);
        }
    }

    public static String getValidJavascriptName(String s) {
        StringBuffer buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte[] bytes;
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                if (buf == null) continue;
                buf.append(c);
                continue;
            }
            if (buf == null) {
                buf = new StringBuffer(s.length() + 10);
                buf.append(s.substring(0, i));
            }
            buf.append('_');
            if (c < '\u0010') {
                buf.append('0');
            }
            if (c < '\u0080') {
                buf.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            try {
                bytes = Character.toString(c).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < bytes.length; ++j) {
                int intVal = bytes[j];
                if (intVal < 0) {
                    intVal = 256 + intVal;
                } else if (intVal < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(intVal).toUpperCase());
            }
        }
        return buf == null ? s : buf.toString();
    }
}

