/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.BroadcastGroupConfiguration;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.BroadcastGroup;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.cluster.impl.BridgeImpl;
import org.hornetq.core.server.cluster.impl.BroadcastGroupImpl;
import org.hornetq.core.server.cluster.impl.ClusterConnectionImpl;
import org.hornetq.core.server.cluster.impl.ClusterManagerInternal;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.Future;
import org.hornetq.utils.UUID;

public class ClusterManagerImpl
implements ClusterManagerInternal {
    private static final Logger log = Logger.getLogger(ClusterManagerImpl.class);
    private final Map<String, BroadcastGroup> broadcastGroups = new HashMap<String, BroadcastGroup>();
    private final Map<String, Bridge> bridges = new HashMap<String, Bridge>();
    private final ExecutorFactory executorFactory;
    private final HornetQServer server;
    private final PostOffice postOffice;
    private final ScheduledExecutorService scheduledExecutor;
    private ClusterConnection defaultClusterConnection;
    private final ManagementService managementService;
    private final Configuration configuration;
    private final UUID nodeUUID;
    private volatile boolean started;
    private volatile boolean backup;
    private final boolean clustered;
    private final Map<String, ClusterConnection> clusterConnections = new HashMap<String, ClusterConnection>();
    private final Set<ServerLocatorInternal> clusterLocators = new ConcurrentHashSet<ServerLocatorInternal>();
    private final Executor executor;

    public ClusterManagerImpl(ExecutorFactory executorFactory, HornetQServer server, PostOffice postOffice, ScheduledExecutorService scheduledExecutor, ManagementService managementService, Configuration configuration, UUID nodeUUID, boolean backup, boolean clustered) {
        if (nodeUUID == null) {
            throw new IllegalArgumentException("Node uuid is null");
        }
        this.executorFactory = executorFactory;
        this.executor = executorFactory.getExecutor();
        this.server = server;
        this.postOffice = postOffice;
        this.scheduledExecutor = scheduledExecutor;
        this.managementService = managementService;
        this.configuration = configuration;
        this.nodeUUID = nodeUUID;
        this.backup = backup;
        this.clustered = clustered;
    }

    @Override
    public String describe() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("Information on " + this);
        out.println("*******************************************************");
        for (ClusterConnection conn : this.cloneClusterConnections()) {
            out.println(conn.describe());
        }
        out.println("*******************************************************");
        return str.toString();
    }

    @Override
    public ClusterConnection getDefaultConnection(TransportConfiguration acceptorConfig) {
        if (acceptorConfig == null) {
            return this.defaultClusterConnection;
        }
        if (this.defaultClusterConnection != null && this.defaultClusterConnection.getConnector().isEquivalent(acceptorConfig)) {
            return this.defaultClusterConnection;
        }
        for (ClusterConnection conn : this.cloneClusterConnections()) {
            if (!conn.getConnector().isEquivalent(acceptorConfig)) continue;
            return conn;
        }
        return null;
    }

    public String toString() {
        return "ClusterManagerImpl[server=" + this.server + "]@" + System.identityHashCode(this);
    }

    @Override
    public String getNodeId() {
        return this.nodeUUID.toString();
    }

    @Override
    public synchronized void deploy() throws Exception {
        if (this.clustered) {
            for (BroadcastGroupConfiguration broadcastGroupConfiguration : this.configuration.getBroadcastGroupConfigurations()) {
                this.deployBroadcastGroup(broadcastGroupConfiguration);
            }
            for (ClusterConnectionConfiguration clusterConnectionConfiguration : this.configuration.getClusterConfigurations()) {
                this.deployClusterConnection(clusterConnectionConfiguration);
            }
        }
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        for (BroadcastGroup group : this.broadcastGroups.values()) {
            if (this.backup) continue;
            group.start();
        }
        for (ClusterConnection conn : this.clusterConnections.values()) {
            conn.start();
            if (!this.backup) continue;
            conn.informTopology();
            conn.announceBackup();
        }
        for (BridgeConfiguration config : this.configuration.getBridgeConfigurations()) {
            this.deployBridge(config, !this.backup);
        }
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        ClusterManagerImpl clusterManagerImpl = this;
        synchronized (clusterManagerImpl) {
            if (!this.started) {
                return;
            }
            if (this.clustered) {
                for (BroadcastGroup group : this.broadcastGroups.values()) {
                    group.stop();
                    this.managementService.unregisterBroadcastGroup(group.getName());
                }
                this.broadcastGroups.clear();
                for (ClusterConnection clusterConnection : this.clusterConnections.values()) {
                    clusterConnection.stop();
                    this.managementService.unregisterCluster(clusterConnection.getName().toString());
                }
            }
            for (Bridge bridge : this.bridges.values()) {
                bridge.stop();
                this.managementService.unregisterBridge(bridge.getName().toString());
            }
            this.bridges.clear();
        }
        for (ServerLocatorInternal clusterLocator : this.clusterLocators) {
            try {
                clusterLocator.close();
            }
            catch (Exception e) {
                log.warn("Error closing serverLocator=" + clusterLocator + ", message=" + e.getMessage(), e);
            }
        }
        this.clusterLocators.clear();
        this.started = false;
        this.clearClusterConnections();
    }

    @Override
    public void flushExecutor() {
        Future future = new Future();
        this.executor.execute(future);
        if (!future.await(10000L)) {
            this.server.threadDump("Couldn't flush ClusterManager executor (" + this + ") in 10 seconds, verify your thread pool size");
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Map<String, Bridge> getBridges() {
        return new HashMap<String, Bridge>(this.bridges);
    }

    @Override
    public Set<ClusterConnection> getClusterConnections() {
        return new HashSet<ClusterConnection>(this.clusterConnections.values());
    }

    @Override
    public Set<BroadcastGroup> getBroadcastGroups() {
        return new HashSet<BroadcastGroup>(this.broadcastGroups.values());
    }

    @Override
    public ClusterConnection getClusterConnection(String name) {
        return this.clusterConnections.get(name);
    }

    @Override
    public synchronized void activate() {
        if (this.backup) {
            this.backup = false;
            for (BroadcastGroup broadcastGroup : this.broadcastGroups.values()) {
                try {
                    broadcastGroup.start();
                }
                catch (Exception e) {
                    log.warn("unable to start broadcast group " + broadcastGroup.getName(), e);
                }
            }
            for (ClusterConnection clusterConnection : this.clusterConnections.values()) {
                try {
                    clusterConnection.activate();
                }
                catch (Exception e) {
                    log.warn("unable to start cluster connection " + clusterConnection.getName(), e);
                }
            }
            for (Bridge bridge : this.bridges.values()) {
                try {
                    bridge.start();
                }
                catch (Exception e) {
                    log.warn("unable to start bridge " + bridge.getName(), e);
                }
            }
        }
    }

    @Override
    public void announceBackup() throws Exception {
        for (ClusterConnection conn : this.cloneClusterConnections()) {
            conn.announceBackup();
        }
    }

    @Override
    public void addClusterLocator(ServerLocatorInternal serverLocator) {
        this.clusterLocators.add(serverLocator);
    }

    @Override
    public void removeClusterLocator(ServerLocatorInternal serverLocator) {
        this.clusterLocators.remove(serverLocator);
    }

    @Override
    public synchronized void deployBridge(BridgeConfiguration config, boolean start) throws Exception {
        ServerLocatorInternal serverLocator;
        if (config.getName() == null) {
            log.warn("Must specify a unique name for each bridge. This one will not be deployed.");
            return;
        }
        if (config.getQueueName() == null) {
            log.warn("Must specify a queue name for each bridge. This one will not be deployed.");
            return;
        }
        if (config.getForwardingAddress() == null) {
            log.debug("Forward address is not specified. Will use original message address instead");
        }
        if (this.bridges.containsKey(config.getName())) {
            log.warn("There is already a bridge with name " + config.getName() + " deployed. This one will not be deployed.");
            return;
        }
        Transformer transformer = this.instantiateTransformer(config.getTransformerClassName());
        Binding binding = this.postOffice.getBinding(new SimpleString(config.getQueueName()));
        if (binding == null) {
            log.warn("No queue found with name " + config.getQueueName() + " bridge will not be deployed.");
            return;
        }
        Queue queue = (Queue)binding.getBindable();
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration discoveryGroupConfiguration = this.configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (discoveryGroupConfiguration == null) {
                log.warn("No discovery group configured with name '" + config.getDiscoveryGroupName() + "'. The bridge will not be deployed.");
                return;
            }
            serverLocator = config.isHA() ? (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA(discoveryGroupConfiguration) : (ServerLocatorInternal)HornetQClient.createServerLocatorWithoutHA(discoveryGroupConfiguration);
        } else {
            TransportConfiguration[] tcConfigs = this.connectorNameListToArray(config.getStaticConnectors());
            if (tcConfigs == null) {
                return;
            }
            serverLocator = config.isHA() ? (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA(tcConfigs) : (ServerLocatorInternal)HornetQClient.createServerLocatorWithoutHA(tcConfigs);
        }
        serverLocator.setConfirmationWindowSize(config.getConfirmationWindowSize());
        serverLocator.setReconnectAttempts(0);
        serverLocator.setInitialConnectAttempts(-1);
        serverLocator.setRetryInterval(config.getRetryInterval());
        serverLocator.setMaxRetryInterval(config.getMaxRetryInterval());
        serverLocator.setRetryIntervalMultiplier(config.getRetryIntervalMultiplier());
        serverLocator.setClientFailureCheckPeriod(config.getClientFailureCheckPeriod());
        serverLocator.setBlockOnDurableSend(!config.isUseDuplicateDetection());
        serverLocator.setBlockOnNonDurableSend(!config.isUseDuplicateDetection());
        serverLocator.setMinLargeMessageSize(config.getMinLargeMessageSize());
        serverLocator.setProducerWindowSize(-1);
        serverLocator.setCallTimeout(config.getCallTimeout());
        if (!config.isUseDuplicateDetection()) {
            log.debug("Bridge " + config.getName() + " is configured to not use duplicate detecion, it will send messages synchronously");
        }
        this.clusterLocators.add(serverLocator);
        BridgeImpl bridge = new BridgeImpl(serverLocator, config.getReconnectAttempts(), config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getMaxRetryInterval(), this.nodeUUID, new SimpleString(config.getName()), queue, this.executorFactory.getExecutor(), SimpleString.toSimpleString(config.getFilterString()), SimpleString.toSimpleString(config.getForwardingAddress()), this.scheduledExecutor, transformer, config.isUseDuplicateDetection(), config.getUser(), config.getPassword(), !this.backup, this.server.getStorageManager());
        this.bridges.put(config.getName(), bridge);
        this.managementService.registerBridge(bridge, config);
        if (start) {
            bridge.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyBridge(String name) throws Exception {
        Bridge bridge;
        ClusterManagerImpl clusterManagerImpl = this;
        synchronized (clusterManagerImpl) {
            bridge = this.bridges.remove(name);
            if (bridge != null) {
                bridge.stop();
                this.managementService.unregisterBridge(name);
            }
        }
        if (bridge != null) {
            bridge.flushExecutor();
        }
    }

    public void clear() {
        for (Bridge bridge : this.bridges.values()) {
            try {
                bridge.stop();
            }
            catch (Exception e) {
                log.warn(e.getMessage(), e);
            }
        }
        this.bridges.clear();
        for (ClusterConnection clusterConnection : this.clusterConnections.values()) {
            try {
                clusterConnection.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.clearClusterConnections();
    }

    private void clearClusterConnections() {
        this.clusterConnections.clear();
        this.defaultClusterConnection = null;
    }

    private void deployClusterConnection(ClusterConnectionConfiguration config) throws Exception {
        ClusterConnectionImpl clusterConnection;
        if (config.getName() == null) {
            log.warn("Must specify a unique name for each cluster connection. This one will not be deployed.");
            return;
        }
        if (config.getAddress() == null) {
            log.warn("Must specify an address for each cluster connection. This one will not be deployed.");
            return;
        }
        TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(config.getConnectorName());
        if (connector == null) {
            log.warn("No connecor with name '" + config.getConnectorName() + "'. The cluster connection will not be deployed.");
            return;
        }
        if (this.clusterConnections.containsKey(config.getName())) {
            log.warn("Cluster Configuration  '" + config.getConnectorName() + "' already exists. The cluster connection will not be deployed.", new Exception("trace"));
            return;
        }
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration dg = this.configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (dg == null) {
                log.warn("No discovery group with name '" + config.getDiscoveryGroupName() + "'. The cluster connection will not be deployed.");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(this + " Starting a Discovery Group Cluster Connection, name=" + config.getDiscoveryGroupName() + ", dg=" + dg);
            }
            clusterConnection = new ClusterConnectionImpl(this, dg, connector, new SimpleString(config.getName()), new SimpleString(config.getAddress()), config.getMinLargeMessageSize(), config.getClientFailureCheckPeriod(), config.getConnectionTTL(), config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getMaxRetryInterval(), config.getReconnectAttempts(), config.getCallTimeout(), config.isDuplicateDetection(), config.isForwardWhenNoConsumers(), config.getConfirmationWindowSize(), this.executorFactory, this.server, this.postOffice, this.managementService, this.scheduledExecutor, config.getMaxHops(), this.nodeUUID, this.backup, this.server.getConfiguration().getClusterUser(), this.server.getConfiguration().getClusterPassword(), config.isAllowDirectConnectionsOnly());
        } else {
            Object[] tcConfigs;
            Object[] objectArray = tcConfigs = config.getStaticConnectors() != null ? this.connectorNameListToArray(config.getStaticConnectors()) : null;
            if (log.isDebugEnabled()) {
                log.debug(this + " defining cluster connection towards " + Arrays.toString(tcConfigs));
            }
            clusterConnection = new ClusterConnectionImpl((ClusterManagerInternal)this, (TransportConfiguration[])tcConfigs, connector, new SimpleString(config.getName()), new SimpleString(config.getAddress()), config.getMinLargeMessageSize(), config.getClientFailureCheckPeriod(), config.getConnectionTTL(), config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getMaxRetryInterval(), config.getReconnectAttempts(), config.getCallTimeout(), config.isDuplicateDetection(), config.isForwardWhenNoConsumers(), config.getConfirmationWindowSize(), this.executorFactory, this.server, this.postOffice, this.managementService, this.scheduledExecutor, config.getMaxHops(), this.nodeUUID, this.backup, this.server.getConfiguration().getClusterUser(), this.server.getConfiguration().getClusterPassword(), config.isAllowDirectConnectionsOnly());
        }
        if (this.defaultClusterConnection == null) {
            this.defaultClusterConnection = clusterConnection;
        }
        this.managementService.registerCluster(clusterConnection, config);
        this.clusterConnections.put(config.getName(), clusterConnection);
        if (log.isDebugEnabled()) {
            log.debug("ClusterConnection.start at " + clusterConnection, new Exception("trace"));
        }
    }

    private Transformer instantiateTransformer(String transformerClassName) {
        Transformer transformer = null;
        if (transformerClassName != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clz = loader.loadClass(transformerClassName);
                transformer = (Transformer)clz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error instantiating transformer class \"" + transformerClassName + "\"", e);
            }
        }
        return transformer;
    }

    private synchronized void deployBroadcastGroup(BroadcastGroupConfiguration config) throws Exception {
        if (this.broadcastGroups.containsKey(config.getName())) {
            log.warn("There is already a broadcast-group with name " + config.getName() + " deployed. This one will not be deployed.");
            return;
        }
        InetAddress localAddress = null;
        if (config.getLocalBindAddress() != null) {
            localAddress = InetAddress.getByName(config.getLocalBindAddress());
        }
        InetAddress groupAddress = InetAddress.getByName(config.getGroupAddress());
        BroadcastGroupImpl group = new BroadcastGroupImpl(this.nodeUUID.toString(), config.getName(), localAddress, config.getLocalBindPort(), groupAddress, config.getGroupPort(), this.scheduledExecutor, config.getBroadcastPeriod());
        for (String connectorInfo : config.getConnectorInfos()) {
            TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(connectorInfo);
            if (connector == null) {
                this.logWarnNoConnector(config.getName(), connectorInfo);
                return;
            }
            group.addConnector(connector);
        }
        this.broadcastGroups.put(config.getName(), group);
        this.managementService.registerBroadcastGroup(group, config);
    }

    private void logWarnNoConnector(String connectorName, String bgName) {
        log.warn("There is no connector deployed with name '" + connectorName + "'. The broadcast group with name '" + bgName + "' will not be deployed.");
    }

    private TransportConfiguration[] connectorNameListToArray(List<String> connectorNames) {
        TransportConfiguration[] tcConfigs = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, connectorNames.size());
        int count = 0;
        for (String connectorName : connectorNames) {
            TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(connectorName);
            if (connector == null) {
                log.warn("No connector defined with name '" + connectorName + "'. The bridge will not be deployed.");
                return null;
            }
            tcConfigs[count++] = connector;
        }
        return tcConfigs;
    }

    private synchronized Collection<ClusterConnection> cloneClusterConnections() {
        ArrayList<ClusterConnection> list = new ArrayList<ClusterConnection>(this.clusterConnections.size());
        list.addAll(this.clusterConnections.values());
        return list;
    }
}

