/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.dd;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.XDocletModulesEjbMessages;
import xdoclet.modules.ejb.home.HomeTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XTag;

public class EjbRefTagsHandler
extends EjbTagsHandler {
    protected transient String referringClassId;

    public String ejbRefId() throws XDocletException {
        return this.referringClassId + '_' + EjbTagsHandler.getEjbIdFor(EjbRefTagsHandler.getCurrentClass());
    }

    public void forAllEjbRefs(String template, Properties attributes) throws XDocletException {
        Log log = LogUtil.getLog(EjbRefTagsHandler.class, (String)"forAllEjbRefs");
        boolean superclasses = TypeConversionUtil.stringToBoolean((String)attributes.getProperty("superclasses"), (boolean)true);
        XClass oldCurClass = EjbRefTagsHandler.getCurrentClass();
        XClass currentClass = EjbRefTagsHandler.getCurrentClass();
        HashMap<String, XTag> already = new HashMap<String, XTag>();
        do {
            List tags = currentClass.getDoc().getTags("ejb.ejb-ref");
            for (XTag tag : tags) {
                EjbRefTagsHandler.setCurrentClassTag((XTag)tag);
                this.storeReferringClassId();
                String ejbNameAttribute = tag.getAttributeValue("ejb-name");
                if (ejbNameAttribute == null || ejbNameAttribute.length() < 1) {
                    EjbRefTagsHandler.mandatoryParamNotFound((XDoc)tag.getDoc(), (String)"ejb-name", (String)"ejb.ejb-ref");
                }
                XClass refedEJBClass = this.findEjb(ejbNameAttribute);
                EjbRefTagsHandler.setCurrentClass((XClass)refedEJBClass);
                String refName = EjbTagsHandler.ejbRefName();
                if (!already.containsKey(refName)) {
                    already.put(refName, tag);
                    EjbRefTagsHandler.pushCurrentClass((XClass)refedEJBClass);
                    this.generate(template);
                    EjbRefTagsHandler.popCurrentClass();
                } else {
                    XTag previousTag = (XTag)already.get(refName);
                    if (!previousTag.getAttributeValue("ejb-name").equals(tag.getAttributeValue("ejb-name")) || !previousTag.getAttributeValue("jndi-name").equals(tag.getAttributeValue("jndi-name"))) {
                        log.error((Object)"Duplicate @ejb.ejb-ref found with different parameters!");
                        log.error((Object)("Previous tag: @ejb.ejb-ref ref-name=\"" + previousTag.getAttributeValue("ref-name") + "\" ejb-name=\"" + previousTag.getAttributeValue("ejb-name") + "\" view-type=\"" + previousTag.getAttributeValue("view-type") + "\""));
                        log.error((Object)("Current tag: @ejb.ejb-ref ref-name=\"" + tag.getAttributeValue("ref-name") + "\" ejb-name=\"" + tag.getAttributeValue("ejb-name") + "\" view-type=\"" + tag.getAttributeValue("view-type") + "\""));
                        throw new XDocletException("Duplicate @ejb.ejb-ref with different parameters");
                    }
                    log.warn((Object)("Duplicated @ejb.ejb-ref found, ref-name=\"" + refName + "\""));
                }
                EjbRefTagsHandler.setCurrentClassTag(null);
                this.referringClassId = null;
            }
        } while (superclasses && (currentClass = currentClass.getSuperclass()) != null);
        EjbRefTagsHandler.setCurrentClass((XClass)oldCurClass);
    }

    public String ejbRefJndiName() throws XDocletException {
        String ejbRefJndiName = null;
        String jndiNameParameter = EjbRefTagsHandler.getCurrentClassTag().getAttributeValue("jndi-name");
        if (jndiNameParameter != null) {
            ejbRefJndiName = jndiNameParameter;
        } else {
            String refed_ejb_name = EjbRefTagsHandler.getCurrentClassTag().getAttributeValue("ejb-name");
            if (refed_ejb_name == null) {
                throw new XDocletException("No ejb-name attribute found in ejb-ref specified in bean " + EjbRefTagsHandler.getCurrentClass());
            }
            XClass refed_clazz = this.findEjb(refed_ejb_name);
            String ejb_type = EjbRefTagsHandler.isLocalEjb(refed_clazz) ? "local" : "remote";
            ejbRefJndiName = HomeTagsHandler.getJndiNameOfTypeFor(ejb_type, refed_clazz);
        }
        return ejbRefJndiName;
    }

    public void ifLocalEjbRef(String template) throws XDocletException {
        if (this.isLocalEjbRef(EjbRefTagsHandler.getCurrentClassTag())) {
            this.generate(template);
        }
    }

    public void ifRemoteEjbRef(String template) throws XDocletException {
        if (this.isRemoteEjbRef(EjbRefTagsHandler.getCurrentClassTag())) {
            this.generate(template);
        }
    }

    protected boolean isLocalEjbRef(XTag ejbRefTag) throws XDocletException {
        String viewTypeParameter = ejbRefTag.getAttributeValue("view-type");
        if (viewTypeParameter == null) {
            return EjbRefTagsHandler.isLocalEjb(EjbRefTagsHandler.getCurrentClass()) && !EjbRefTagsHandler.isRemoteEjb(EjbRefTagsHandler.getCurrentClass());
        }
        return "local".equals(viewTypeParameter);
    }

    protected boolean isRemoteEjbRef(XTag ejbRefTag) throws XDocletException {
        return !this.isLocalEjbRef(ejbRefTag);
    }

    protected void storeReferringClassId() throws XDocletException {
        this.referringClassId = EjbTagsHandler.getEjbIdFor(EjbRefTagsHandler.getCurrentClass());
    }

    protected XClass findEjb(String ejbName) throws XDocletException {
        Collection classes = EjbRefTagsHandler.getXJavaDoc().getSourceClasses();
        for (XClass clazz : classes) {
            if (!EjbRefTagsHandler.isEjb(clazz) || !ejbName.equals(EjbRefTagsHandler.getEjbNameFor(clazz))) continue;
            return clazz;
        }
        throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"NOT_DEFINED", (String[])new String[]{ejbName}));
    }
}

