/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.exception;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.rhq.core.util.exception.Severity;
import org.rhq.core.util.exception.ThrowableUtil;

public class ExceptionPackage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String exceptionName;
    private final Severity severity;
    private final String message;
    private final ExceptionPackage cause;
    private final String stackTrace;
    private final String allMessages;

    public ExceptionPackage(Throwable throwable) throws IllegalArgumentException {
        this(null, throwable);
    }

    public ExceptionPackage(Severity severity, Throwable throwable) throws IllegalArgumentException {
        if (throwable == null) {
            throw new IllegalArgumentException("throwable==null");
        }
        this.exceptionName = throwable.getClass().getName();
        this.severity = severity == null ? Severity.Warning : severity;
        this.message = throwable.getMessage();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        throwable.printStackTrace(pw);
        pw.flush();
        this.stackTrace = baos.toString();
        this.cause = throwable.getCause() != null ? new ExceptionPackage(severity, throwable.getCause()) : null;
        this.allMessages = ThrowableUtil.getAllMessages(throwable);
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public ExceptionPackage getCause() {
        return this.cause;
    }

    public String getStackTraceString() {
        return this.stackTrace;
    }

    public String getAllMessages() {
        return this.allMessages;
    }

    public String toString() {
        return this.exceptionName + ": [" + this.severity.toString() + "] " + this.message;
    }
}

