/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.framework;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.transaction.SystemException;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.framework.Query;
import org.jboss.seam.persistence.PersistenceProvider;
import org.jboss.seam.persistence.QueryParser;
import org.jboss.seam.transaction.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityQuery<E>
extends Query<EntityManager, E> {
    private List<E> resultList;
    private E singleResult;
    private Long resultCount;
    private Map<String, String> hints;

    @Override
    public void validate() {
        super.validate();
        if (this.getEntityManager() == null) {
            throw new IllegalStateException("entityManager is null");
        }
        if (!PersistenceProvider.instance().supportsFeature(PersistenceProvider.Feature.WILDCARD_AS_COUNT_QUERY_SUBJECT)) {
            this.setUseWildcardAsCountQuerySubject(false);
        }
    }

    @Override
    @Transactional
    public boolean isNextExists() {
        return this.resultList != null && this.getMaxResults() != null && this.resultList.size() > this.getMaxResults();
    }

    @Override
    @Transactional
    public List<E> getResultList() {
        if (this.isAnyParameterDirty()) {
            this.refresh();
        }
        this.initResultList();
        return this.truncResultList(this.resultList);
    }

    private void initResultList() {
        if (this.resultList == null) {
            javax.persistence.Query query = this.createQuery();
            this.resultList = query == null ? null : query.getResultList();
        }
    }

    @Override
    @Transactional
    public E getSingleResult() {
        if (this.isAnyParameterDirty()) {
            this.refresh();
        }
        this.initSingleResult();
        return this.singleResult;
    }

    private void initSingleResult() {
        if (this.singleResult == null) {
            javax.persistence.Query query = this.createQuery();
            this.singleResult = query == null ? null : query.getSingleResult();
        }
    }

    @Override
    @Transactional
    public Long getResultCount() {
        if (this.isAnyParameterDirty()) {
            this.refresh();
        }
        this.initResultCount();
        return this.resultCount;
    }

    private void initResultCount() {
        if (this.resultCount == null) {
            javax.persistence.Query query = this.createCountQuery();
            this.resultCount = query == null ? null : (Long)query.getSingleResult();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.resultCount = null;
        this.resultList = null;
        this.singleResult = null;
    }

    public EntityManager getEntityManager() {
        return (EntityManager)this.getPersistenceContext();
    }

    public void setEntityManager(EntityManager entityManager) {
        this.setPersistenceContext(entityManager);
    }

    @Override
    protected String getPersistenceContextName() {
        return "entityManager";
    }

    protected javax.persistence.Query createQuery() {
        this.parseEjbql();
        this.evaluateAllParameters();
        this.joinTransaction();
        javax.persistence.Query query = this.getEntityManager().createQuery(this.getRenderedEjbql());
        this.setParameters(query, this.getQueryParameterValues(), 0);
        this.setParameters(query, this.getRestrictionParameterValues(), this.getQueryParameterValues().size());
        if (this.getFirstResult() != null) {
            query.setFirstResult(this.getFirstResult().intValue());
        }
        if (this.getMaxResults() != null) {
            query.setMaxResults(this.getMaxResults() + 1);
        }
        if (this.getHints() != null) {
            for (Map.Entry<String, String> me : this.getHints().entrySet()) {
                query.setHint(me.getKey(), (Object)me.getValue());
            }
        }
        return query;
    }

    protected javax.persistence.Query createCountQuery() {
        this.parseEjbql();
        this.evaluateAllParameters();
        this.joinTransaction();
        javax.persistence.Query query = this.getEntityManager().createQuery(this.getCountEjbql());
        this.setParameters(query, this.getQueryParameterValues(), 0);
        this.setParameters(query, this.getRestrictionParameterValues(), this.getQueryParameterValues().size());
        return query;
    }

    private void setParameters(javax.persistence.Query query, List<Object> parameters, int start) {
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameterValue = parameters.get(i);
            if (!this.isRestrictionParameterSet(parameterValue)) continue;
            query.setParameter(QueryParser.getParameterName(start + i), parameterValue);
        }
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    public void setHints(Map<String, String> hints) {
        this.hints = hints;
    }

    protected void joinTransaction() {
        try {
            Transaction.instance().enlist(this.getEntityManager());
        }
        catch (SystemException se) {
            throw new RuntimeException("could not join transaction", se);
        }
    }
}

