/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.transaction.CMTTransaction;
import org.jboss.seam.transaction.NoTransaction;
import org.jboss.seam.transaction.UTTransaction;
import org.jboss.seam.transaction.UserTransaction;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Naming;

@Name(value="org.jboss.seam.transaction.transaction")
@Scope(value=ScopeType.EVENT)
@Install(precedence=0)
@BypassInterceptors
public class Transaction {
    public static final String TRANSACTION_FAILED = "org.jboss.seam.transaction.transactionFailed";

    public static UserTransaction instance() {
        return (UserTransaction)Component.getInstance(Transaction.class, ScopeType.EVENT);
    }

    @Unwrap
    public UserTransaction getTransaction() throws NamingException {
        try {
            return this.createUTTransaction();
        }
        catch (NameNotFoundException nnfe) {
            try {
                return this.createCMTTransaction();
            }
            catch (NameNotFoundException nnfe2) {
                return this.createNoTransaction();
            }
        }
    }

    protected UserTransaction createNoTransaction() {
        return new NoTransaction();
    }

    protected UserTransaction createCMTTransaction() throws NamingException {
        return new CMTTransaction(EJB.getEJBContext());
    }

    protected UserTransaction createUTTransaction() throws NamingException {
        return new UTTransaction(this.getUserTransaction());
    }

    protected javax.transaction.UserTransaction getUserTransaction() throws NamingException {
        InitialContext context = Naming.getInitialContext();
        try {
            return (javax.transaction.UserTransaction)context.lookup("java:comp/UserTransaction");
        }
        catch (NamingException ne) {
            try {
                return (javax.transaction.UserTransaction)context.lookup("java:jboss/UserTransaction");
            }
            catch (Exception cause) {
                try {
                    javax.transaction.UserTransaction ut = (javax.transaction.UserTransaction)context.lookup("UserTransaction");
                    ut.getStatus();
                    return ut;
                }
                catch (Exception e) {
                    throw ne;
                }
            }
        }
    }
}

