/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc2.access;

import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cache.jbc2.BasicRegionAdapter;
import org.hibernate.cache.jbc2.util.CacheHelper;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;

public class TransactionalAccessDelegate {
    protected final Cache cache;
    protected final Fqn regionFqn;
    protected final BasicRegionAdapter region;

    public TransactionalAccessDelegate(BasicRegionAdapter adapter) {
        this.region = adapter;
        this.cache = adapter.getCacheInstance();
        this.regionFqn = adapter.getRegionFqn();
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        if (!this.region.checkValid()) {
            return null;
        }
        this.region.ensureRegionRootExists();
        return CacheHelper.get(this.cache, this.regionFqn, key);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        this.region.ensureRegionRootExists();
        return CacheHelper.putForExternalRead(this.cache, this.regionFqn, key, value);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        this.region.ensureRegionRootExists();
        return CacheHelper.putForExternalRead(this.cache, this.regionFqn, key, value);
    }

    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    public boolean insert(Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        this.region.ensureRegionRootExists();
        CacheHelper.put(this.cache, this.regionFqn, key, value);
        return true;
    }

    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.region.ensureRegionRootExists();
        CacheHelper.put(this.cache, this.regionFqn, key, value);
        return true;
    }

    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        return false;
    }

    public void remove(Object key) throws CacheException {
        this.region.ensureRegionRootExists();
        CacheHelper.remove(this.cache, this.regionFqn, key);
    }

    public void removeAll() throws CacheException {
        CacheHelper.removeAll(this.cache, this.regionFqn);
    }

    public void evict(Object key) throws CacheException {
        this.region.ensureRegionRootExists();
        CacheHelper.remove(this.cache, this.regionFqn, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() throws CacheException {
        Transaction tx = this.region.suspend();
        try {
            this.region.ensureRegionRootExists();
            CacheHelper.sendEvictAllNotification(this.cache, this.regionFqn, this.region.getMemberId(), null);
        }
        finally {
            this.region.resume(tx);
        }
    }
}

