/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import xdoclet.XDocletMessages;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;

public final class FileManager {
    private static final int BUFFER_SIZE = 10240;
    private static final Map urlCache = new HashMap();

    public static synchronized String getURLContent(URL url) {
        Log log = LogUtil.getLog(FileManager.class, "getURLContent");
        if (url == null) {
            throw new IllegalArgumentException("url shouldn't be null!");
        }
        String content = (String)urlCache.get(url);
        if (content != null) {
            return content;
        }
        try {
            InputStream is = null;
            is = "file".equals(url.getProtocol()) ? new FileInputStream(url.getFile()) : url.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(is.available());
            FileManager.pump(is, baos);
            content = new String(baos.toByteArray());
            urlCache.put(url, content);
            return content;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)Translator.getString(XDocletMessages.class, "EXCEPTION_READING_MERGE_FILE", new String[]{e.toString()}));
            return null;
        }
    }

    public static synchronized void writeURLContent(URL url, File destination) throws IOException {
        FileOutputStream fos = new FileOutputStream(destination);
        FileManager.pump(url.openStream(), fos);
        fos.flush();
        fos.close();
    }

    private static void pump(InputStream is, OutputStream os) throws IOException {
        int lengthRead;
        byte[] buffer = new byte[10240];
        while ((lengthRead = is.read(buffer)) >= 0) {
            os.write(buffer, 0, lengthRead);
        }
    }
}

