/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.utils.UUIDGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportConfiguration
implements Serializable {
    private static final long serialVersionUID = -3994528421527392679L;
    private String name;
    private String factoryClassName;
    private Map<String, Object> params;
    private static final byte TYPE_BOOLEAN = 0;
    private static final byte TYPE_INT = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_STRING = 3;

    public static String[] splitHosts(String commaSeparatedHosts) {
        if (commaSeparatedHosts == null) {
            return new String[0];
        }
        String[] hosts = commaSeparatedHosts.split(",");
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hosts[i].trim();
        }
        return hosts;
    }

    public TransportConfiguration() {
    }

    public TransportConfiguration(String className, Map<String, Object> params, String name) {
        this.factoryClassName = className;
        this.params = params;
        this.name = name;
    }

    public TransportConfiguration(String className, Map<String, Object> params) {
        this(className, params, UUIDGenerator.getInstance().generateStringUUID());
    }

    public TransportConfiguration(String className) {
        this(className, new HashMap<String, Object>(), UUIDGenerator.getInstance().generateStringUUID());
    }

    public String getName() {
        return this.name;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public int hashCode() {
        return this.factoryClassName.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TransportConfiguration)) {
            return false;
        }
        TransportConfiguration kother = (TransportConfiguration)other;
        if (this.factoryClassName.equals(kother.factoryClassName)) {
            if (this.params == null || this.params.isEmpty()) {
                return kother.params == null || kother.params.isEmpty();
            }
            if (kother.params == null || kother.params.isEmpty()) {
                return false;
            }
            if (this.params.size() == kother.params.size()) {
                for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                    Object thisVal = entry.getValue();
                    Object otherVal = kother.params.get(entry.getKey());
                    if (otherVal != null && otherVal.equals(thisVal)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isEquivalent(TransportConfiguration otherConfig) {
        if (this.getFactoryClassName().equals(otherConfig.getFactoryClassName())) {
            return true;
        }
        if (this.getFactoryClassName().contains("Netty") && otherConfig.getFactoryClassName().contains("Netty")) {
            return true;
        }
        return this.getFactoryClassName().contains("InVM") && otherConfig.getFactoryClassName().contains("InVM");
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.replaceWildcardChars(this.factoryClassName));
        if (this.params != null) {
            if (!this.params.isEmpty()) {
                str.append("?");
            }
            boolean first = true;
            for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                if (!first) {
                    str.append("&");
                }
                String encodedKey = this.replaceWildcardChars(entry.getKey());
                String val = entry.getValue().toString();
                String encodedVal = this.replaceWildcardChars(val);
                str.append(encodedKey).append('=').append(encodedVal);
                first = false;
            }
        }
        return str.toString();
    }

    public void encode(HornetQBuffer buffer) {
        buffer.writeString(this.name);
        buffer.writeString(this.factoryClassName);
        buffer.writeInt(this.params == null ? 0 : this.params.size());
        if (this.params != null) {
            for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                buffer.writeString(entry.getKey());
                Object val = entry.getValue();
                if (val instanceof Boolean) {
                    buffer.writeByte((byte)0);
                    buffer.writeBoolean((Boolean)val);
                    continue;
                }
                if (val instanceof Integer) {
                    buffer.writeByte((byte)1);
                    buffer.writeInt((Integer)val);
                    continue;
                }
                if (val instanceof Long) {
                    buffer.writeByte((byte)2);
                    buffer.writeLong((Long)val);
                    continue;
                }
                if (val instanceof String) {
                    buffer.writeByte((byte)3);
                    buffer.writeString((String)val);
                    continue;
                }
                throw new IllegalArgumentException("Invalid type " + val);
            }
        }
    }

    public void decode(HornetQBuffer buffer) {
        this.name = buffer.readString();
        this.factoryClassName = buffer.readString();
        int num = buffer.readInt();
        if (this.params == null) {
            if (num > 0) {
                this.params = new HashMap<String, Object>();
            }
        } else {
            this.params.clear();
        }
        for (int i = 0; i < num; ++i) {
            Object val;
            String key = buffer.readString();
            byte type = buffer.readByte();
            switch (type) {
                case 0: {
                    val = buffer.readBoolean();
                    break;
                }
                case 1: {
                    val = buffer.readInt();
                    break;
                }
                case 2: {
                    val = buffer.readLong();
                    break;
                }
                case 3: {
                    val = buffer.readString();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type " + type);
                }
            }
            this.params.put(key, val);
        }
    }

    private String replaceWildcardChars(String str) {
        return str.replace('.', '-');
    }
}

