/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CommandConfirmationHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.PacketsConfirmedMessage;

public class ChannelImpl
implements Channel {
    private static final Logger log = Logger.getLogger(ChannelImpl.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private volatile long id;
    private ChannelHandler handler;
    private Packet response;
    private final Queue<Packet> resendCache;
    private volatile int firstStoredCommandID;
    private volatile int lastConfirmedCommandID = -1;
    private volatile CoreRemotingConnection connection;
    private volatile boolean closed;
    private final Lock lock = new ReentrantLock();
    private final Condition sendCondition = this.lock.newCondition();
    private final Condition failoverCondition = this.lock.newCondition();
    private final Object sendLock = new Object();
    private final Object sendBlockingLock = new Object();
    private boolean failingOver;
    private final int confWindowSize;
    private int receivedBytes;
    private CommandConfirmationHandler commandConfirmationHandler;
    private volatile boolean transferring;

    public ChannelImpl(CoreRemotingConnection connection, long id, int confWindowSize) {
        this.connection = connection;
        this.id = id;
        this.confWindowSize = confWindowSize;
        this.resendCache = confWindowSize != -1 ? new ConcurrentLinkedQueue<Packet>() : null;
    }

    public boolean supports(byte packetType) {
        int version = this.connection.getClientVersion();
        switch (packetType) {
            case 114: {
                return version >= 122;
            }
        }
        return true;
    }

    public long getID() {
        return this.id;
    }

    public int getLastConfirmedCommandID() {
        return this.lastConfirmedCommandID;
    }

    public Lock getLock() {
        return this.lock;
    }

    public int getConfirmationWindowSize() {
        return this.confWindowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBlocking() {
        this.lock.lock();
        try {
            this.response = new HornetQExceptionMessage(new HornetQException(5, "Connection failure detected. Unblocking a blocking call that will never get a response"));
            this.sendCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void sendAndFlush(Packet packet) {
        this.send(packet, true, false);
    }

    public void send(Packet packet) {
        this.send(packet, false, false);
    }

    public void sendBatched(Packet packet) {
        this.send(packet, false, true);
    }

    public void setTransferring(boolean transferring) {
        this.transferring = transferring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet packet, boolean flush, boolean batch) {
        Object object = this.sendLock;
        synchronized (object) {
            packet.setChannelID(this.id);
            if (isTrace) {
                log.trace("Sending packet nonblocking " + packet + " on channeID=" + this.id);
            }
            HornetQBuffer buffer = packet.encode(this.connection);
            this.lock.lock();
            try {
                while (this.failingOver) {
                    try {
                        this.failoverCondition.await(10000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {}
                }
                if (this.transferring) {
                    throw new IllegalStateException("Cannot send a packet while channel is doing failover");
                }
                if (this.resendCache != null && packet.isRequiresConfirmations()) {
                    this.resendCache.add(packet);
                }
            }
            finally {
                this.lock.unlock();
            }
            if (isTrace) {
                log.trace("Writing buffer for channelID=" + this.id);
            }
            this.connection.getTransportConnection().write(buffer, flush, batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet sendBlocking(Packet packet) throws HornetQException {
        if (this.closed) {
            throw new HornetQException(2, "Connection is destroyed");
        }
        if (this.connection.getBlockingCallTimeout() == -1L) {
            throw new IllegalStateException("Cannot do a blocking call timeout on a server side connection");
        }
        Object object = this.sendBlockingLock;
        synchronized (object) {
            packet.setChannelID(this.id);
            HornetQBuffer buffer = packet.encode(this.connection);
            this.lock.lock();
            try {
                long now;
                while (this.failingOver) {
                    try {
                        this.failoverCondition.await(10000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {}
                }
                this.response = null;
                if (this.resendCache != null && packet.isRequiresConfirmations()) {
                    this.resendCache.add(packet);
                }
                this.connection.getTransportConnection().write(buffer, false, false);
                long start = System.currentTimeMillis();
                for (long toWait = this.connection.getBlockingCallTimeout(); !this.closed && this.response == null && toWait > 0L; toWait -= now - start) {
                    try {
                        this.sendCondition.await(toWait, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this.closed) break;
                    now = System.currentTimeMillis();
                    start = now;
                }
                if (this.response == null) {
                    throw new HornetQException(3, "Timed out waiting for response when sending packet " + packet.getType());
                }
                if (this.response.getType() == 20) {
                    HornetQExceptionMessage mem = (HornetQExceptionMessage)this.response;
                    HornetQException e = mem.getException();
                    e.fillInStackTrace();
                    throw e;
                }
            }
            finally {
                this.lock.unlock();
            }
            return this.response;
        }
    }

    public void setCommandConfirmationHandler(CommandConfirmationHandler handler) {
        if (this.confWindowSize < 0) {
            throw new IllegalStateException("You can't set confirmationHandler on a connection with confirmation-window-size < 0. Look at the documentation for more information.");
        }
        this.commandConfirmationHandler = handler;
    }

    public void setHandler(ChannelHandler handler) {
        this.handler = handler;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (!this.connection.isDestroyed() && !this.connection.removeChannel(this.id)) {
            throw new IllegalArgumentException("Cannot find channel with id " + this.id + " to close");
        }
        if (this.failingOver) {
            this.unlock();
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferConnection(CoreRemotingConnection newConnection) {
        Object object = this.connection.getTransferLock();
        synchronized (object) {
            this.connection.removeChannel(this.id);
            CoreRemotingConnection rnewConnection = newConnection;
            rnewConnection.putChannel(this.id, this);
            this.connection = rnewConnection;
            this.transferring = true;
        }
    }

    public void replayCommands(int otherLastConfirmedCommandID) {
        if (this.resendCache != null) {
            if (isTrace) {
                log.trace("Replaying commands on channelID=" + this.id);
            }
            this.clearUpTo(otherLastConfirmedCommandID);
            for (Packet packet : this.resendCache) {
                this.doWrite(packet);
            }
        }
    }

    public void lock() {
        this.lock.lock();
        this.failingOver = true;
        this.lock.unlock();
    }

    public void unlock() {
        this.lock.lock();
        this.failingOver = false;
        this.failoverCondition.signalAll();
        this.lock.unlock();
    }

    public CoreRemotingConnection getConnection() {
        return this.connection;
    }

    public synchronized void flushConfirmations() {
        if (this.resendCache != null && this.receivedBytes != 0) {
            this.receivedBytes = 0;
            PacketsConfirmedMessage confirmed = new PacketsConfirmedMessage(this.lastConfirmedCommandID);
            confirmed.setChannelID(this.id);
            this.doWrite(confirmed);
        }
    }

    public void confirm(Packet packet) {
        if (this.resendCache != null && packet.isRequiresConfirmations()) {
            ++this.lastConfirmedCommandID;
            this.receivedBytes += packet.getPacketSize();
            if (this.receivedBytes >= this.confWindowSize) {
                this.receivedBytes = 0;
                PacketsConfirmedMessage confirmed = new PacketsConfirmedMessage(this.lastConfirmedCommandID);
                confirmed.setChannelID(this.id);
                this.doWrite(confirmed);
            }
        }
    }

    public void clearCommands() {
        if (this.resendCache != null) {
            this.lastConfirmedCommandID = -1;
            this.firstStoredCommandID = 0;
            this.resendCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacket(Packet packet) {
        if (packet.getType() == 22) {
            if (this.resendCache != null) {
                PacketsConfirmedMessage msg = (PacketsConfirmedMessage)packet;
                this.clearUpTo(msg.getCommandID());
            }
            if (!this.connection.isClient()) {
                this.handler.handlePacket(packet);
            }
            return;
        }
        if (packet.isResponse()) {
            this.confirm(packet);
            this.lock.lock();
            this.response = packet;
            try {
                this.sendCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        } else if (this.handler != null) {
            this.handler.handlePacket(packet);
        }
    }

    private void doWrite(Packet packet) {
        HornetQBuffer buffer = packet.encode(this.connection);
        this.connection.getTransportConnection().write(buffer, false, false);
    }

    private void clearUpTo(int lastReceivedCommandID) {
        int numberToClear = 1 + lastReceivedCommandID - this.firstStoredCommandID;
        if (numberToClear == -1) {
            throw new IllegalArgumentException("Invalid lastReceivedCommandID: " + lastReceivedCommandID);
        }
        int sizeToFree = 0;
        for (int i = 0; i < numberToClear; ++i) {
            Packet packet = this.resendCache.poll();
            if (packet == null) {
                log.warn("Can't find packet to clear:  last received command id " + lastReceivedCommandID + " first stored command id " + this.firstStoredCommandID);
                this.firstStoredCommandID = lastReceivedCommandID + 1;
                return;
            }
            if (packet.getType() != 22) {
                sizeToFree += packet.getPacketSize();
            }
            if (this.commandConfirmationHandler == null) continue;
            this.commandConfirmationHandler.commandConfirmed(packet);
        }
        this.firstStoredCommandID += numberToClear;
    }
}

