/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.AutoTxn;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;

public class UtilizationProfile
implements EnvConfigObserver {
    private EnvironmentImpl env;
    private UtilizationTracker tracker;
    private DatabaseImpl fileSummaryDb;
    private SortedMap fileSummaryMap;
    private boolean cachePopulated;
    private boolean rmwFixEnabled;
    int minUtilization;
    int minFileUtilization;
    int minAge;
    private long[] forceCleanFiles;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UtilizationProfile(EnvironmentImpl env, UtilizationTracker tracker) throws DatabaseException {
        this.env = env;
        this.tracker = tracker;
        this.fileSummaryMap = new TreeMap();
        this.rmwFixEnabled = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_RMW_FIX);
        this.parseForceCleanFiles(env.getConfigManager().get(EnvironmentParams.CLEANER_FORCE_CLEAN_FILES));
        this.envConfigUpdate(env.getConfigManager());
        env.addConfigObserver(this);
    }

    public void envConfigUpdate(DbConfigManager cm) throws DatabaseException {
        this.minAge = cm.getInt(EnvironmentParams.CLEANER_MIN_AGE);
        this.minUtilization = cm.getInt(EnvironmentParams.CLEANER_MIN_UTILIZATION);
        this.minFileUtilization = cm.getInt(EnvironmentParams.CLEANER_MIN_FILE_UTILIZATION);
    }

    public boolean isRMWFixEnabled() {
        return this.rmwFixEnabled;
    }

    synchronized int getNumberOfFiles() throws DatabaseException {
        if (!$assertionsDisabled && !this.cachePopulated) {
            throw new AssertionError();
        }
        return this.fileSummaryMap.size();
    }

    synchronized Long getCheapestFileToClean(SortedSet files) throws DatabaseException {
        if (files.size() == 1) {
            return (Long)files.first();
        }
        if (!$assertionsDisabled && !this.cachePopulated) {
            throw new AssertionError();
        }
        Long bestFile = null;
        int bestCost = Integer.MAX_VALUE;
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            Long file = (Long)iter.next();
            if (!this.fileSummaryMap.containsKey(file)) continue;
            FileSummary summary = this.getFileSummary(file);
            int thisCost = summary.getNonObsoleteCount();
            if (bestFile != null && thisCost >= bestCost) continue;
            bestFile = file;
            bestCost = thisCost;
        }
        return bestFile;
    }

    synchronized Long getBestFileForCleaning(FileSelector fileSelector, boolean forceCleaning, Set lowUtilizationFiles) throws DatabaseException {
        if (lowUtilizationFiles != null) {
            lowUtilizationFiles.clear();
        }
        if (!$assertionsDisabled && !this.cachePopulated) {
            throw new AssertionError();
        }
        if (this.fileSummaryMap.size() == 0) {
            return null;
        }
        int useMinUtilization = this.minUtilization;
        int useMinFileUtilization = this.minFileUtilization;
        int useMinAge = this.minAge;
        long firstActiveLsn = this.env.getCheckpointer().getFirstActiveLsn();
        if (firstActiveLsn == -1L) {
            return null;
        }
        Iterator iter = this.fileSummaryMap.keySet().iterator();
        Long bestFile = null;
        int bestUtilization = 101;
        long totalSize = 0L;
        long totalObsoleteSize = 0L;
        while (iter.hasNext()) {
            Long file = (Long)iter.next();
            long fileNum = file;
            FileSummary summary = this.getFileSummary(file);
            int obsoleteSize = summary.getObsoleteSize();
            if (fileSelector.isFileCleaningInProgress(file)) {
                totalSize += (long)(summary.totalSize - obsoleteSize);
                totalObsoleteSize += (long)this.estimateUPObsoleteSize(summary);
                continue;
            }
            totalSize += (long)summary.totalSize;
            totalObsoleteSize += (long)obsoleteSize;
            if (DbLsn.getFileNumber(firstActiveLsn) - fileNum < (long)useMinAge) continue;
            int thisUtilization = UtilizationProfile.utilization(obsoleteSize, summary.totalSize);
            if (bestFile == null || thisUtilization < bestUtilization) {
                bestFile = file;
                bestUtilization = thisUtilization;
            }
            if (lowUtilizationFiles == null || thisUtilization >= useMinUtilization) continue;
            lowUtilizationFiles.add(file);
        }
        int totalUtilization = UtilizationProfile.utilization(totalObsoleteSize, totalSize);
        if (forceCleaning || totalUtilization < useMinUtilization || bestUtilization < useMinFileUtilization) {
            return bestFile;
        }
        return null;
    }

    public static int utilization(long obsoleteSize, long totalSize) {
        if (totalSize != 0L) {
            return (int)((totalSize - obsoleteSize) * 100L / totalSize);
        }
        return 0;
    }

    private int estimateUPObsoleteSize(FileSummary summary) {
        return 0;
    }

    private synchronized FileSummary getFileSummary(Long file) {
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(file);
        long fileNum = file;
        TrackedFileSummary trackedSummary = this.tracker.getTrackedFile(fileNum);
        if (trackedSummary != null) {
            FileSummary totals = new FileSummary();
            totals.add(summary);
            totals.add(trackedSummary);
            summary = totals;
        }
        if (this.isForceCleanFile(fileNum)) {
            FileSummary allObsolete = new FileSummary();
            allObsolete.add(summary);
            allObsolete.obsoleteLNCount = allObsolete.totalLNCount;
            allObsolete.obsoleteINCount = allObsolete.totalINCount;
            summary = allObsolete;
        }
        return summary;
    }

    private boolean isForceCleanFile(long file) {
        if (this.forceCleanFiles != null) {
            for (int i = 0; i < this.forceCleanFiles.length; i += 2) {
                long from = this.forceCleanFiles[i];
                long to = this.forceCleanFiles[i + 1];
                if (file < from || file > to) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseForceCleanFiles(String propValue) {
        if (propValue == null || propValue.length() == 0) {
            this.forceCleanFiles = null;
            return;
        }
        String errPrefix = "Error in " + EnvironmentParams.CLEANER_FORCE_CLEAN_FILES.getName() + "=" + propValue + ": ";
        StringTokenizer tokens = new StringTokenizer(propValue, ",-", true);
        ArrayList<Long> list = new ArrayList<Long>();
        while (tokens.hasMoreTokens()) {
            long fromNum;
            String fromStr = tokens.nextToken();
            try {
                fromNum = Long.parseLong(fromStr, 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(errPrefix + "Invalid hex file number: " + fromStr);
            }
            long toNum = -1L;
            if (tokens.hasMoreTokens()) {
                String delim = tokens.nextToken();
                if (",".equals(delim)) {
                    toNum = fromNum;
                } else {
                    if (!"-".equals(delim)) throw new IllegalArgumentException(errPrefix + "Expected '-' or ',': " + delim);
                    if (!tokens.hasMoreTokens()) throw new IllegalArgumentException(errPrefix + "Expected file number: " + delim);
                    String toStr = tokens.nextToken();
                    try {
                        toNum = Long.parseLong(toStr, 16);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(errPrefix + "Invalid hex file number: " + toStr);
                    }
                }
            } else {
                toNum = fromNum;
            }
            if (!$assertionsDisabled && toNum == -1L) {
                throw new AssertionError();
            }
            list.add(new Long(fromNum));
            list.add(new Long(toNum));
        }
        this.forceCleanFiles = new long[list.size()];
        for (int i = 0; i < this.forceCleanFiles.length; ++i) {
            this.forceCleanFiles[i] = (Long)list.get(i);
        }
    }

    public void countAndLogSummaries(TrackedFileSummary[] summaries) throws DatabaseException {
        this.env.getLogManager().countObsoleteNodes(summaries);
        if (!DbInternal.getCheckpointUP(this.env.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        for (int i = 0; i < summaries.length; ++i) {
            long fileNum = summaries[i].getFileNumber();
            TrackedFileSummary tfs = this.tracker.getTrackedFile(fileNum);
            if (tfs == null) continue;
            this.flushFileSummary(tfs);
        }
    }

    public synchronized SortedMap getFileSummaryMap(boolean includeTrackedFiles) throws DatabaseException {
        if (!$assertionsDisabled && !this.cachePopulated) {
            throw new AssertionError();
        }
        if (includeTrackedFiles) {
            TreeMap<Long, FileSummary> map = new TreeMap<Long, FileSummary>();
            Iterator iter = this.fileSummaryMap.keySet().iterator();
            while (iter.hasNext()) {
                Long file = (Long)iter.next();
                FileSummary summary = this.getFileSummary(file);
                map.put(file, summary);
            }
            TrackedFileSummary[] trackedFiles = this.tracker.getTrackedFiles();
            for (int i = 0; i < trackedFiles.length; ++i) {
                TrackedFileSummary summary = trackedFiles[i];
                long fileNum = summary.getFileNumber();
                Long file = new Long(fileNum);
                if (map.containsKey(file)) continue;
                map.put(file, summary);
            }
            return map;
        }
        return new TreeMap(this.fileSummaryMap);
    }

    public synchronized void clearCache() {
        int memorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
        MemoryBudget mb = this.env.getMemoryBudget();
        mb.updateMiscMemoryUsage(0 - memorySize);
        this.fileSummaryMap = new TreeMap();
        this.cachePopulated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFile(Long fileNum) throws DatabaseException {
        UtilizationProfile utilizationProfile = this;
        synchronized (utilizationProfile) {
            if (!$assertionsDisabled && !this.cachePopulated) {
                throw new AssertionError();
            }
            if (this.fileSummaryMap.remove(fileNum) != null) {
                MemoryBudget mb = this.env.getMemoryBudget();
                mb.updateMiscMemoryUsage(0 - MemoryBudget.UTILIZATION_PROFILE_ENTRY);
            }
        }
        this.deleteFileSummary(fileNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteFileSummary(Long fileNum) throws DatabaseException {
        CursorImpl cursor;
        BasicLocker locker;
        block12: {
            block10: {
                block11: {
                    locker = null;
                    cursor = null;
                    try {
                        locker = new BasicLocker(this.env);
                        cursor = new CursorImpl(this.fileSummaryDb, locker);
                        DatabaseEntry keyEntry = new DatabaseEntry();
                        DatabaseEntry dataEntry = new DatabaseEntry();
                        long fileNumVal = fileNum;
                        if (!this.getFirstFSLN(cursor, fileNumVal, keyEntry, dataEntry, LockType.WRITE)) {
                            Object var14_7 = null;
                            if (cursor == null) break block10;
                            break block11;
                        }
                        OperationStatus status = OperationStatus.SUCCESS;
                        while (status == OperationStatus.SUCCESS) {
                            this.env.getEvictor().doCriticalEviction();
                            FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                            if (ln != null) {
                                Object var12_13;
                                if (fileNumVal != ln.getFileNumber(keyEntry.getData())) break block12;
                                TrackedFileSummary tfs = this.tracker.getTrackedFile(fileNumVal);
                                if (tfs != null) {
                                    ln.setTrackedSummary(tfs);
                                }
                                cursor.latchBIN();
                                try {
                                    cursor.delete();
                                    var12_13 = null;
                                }
                                catch (Throwable throwable) {
                                    var12_13 = null;
                                    cursor.releaseBIN();
                                    throw throwable;
                                }
                                cursor.releaseBIN();
                            }
                            status = cursor.getNext(keyEntry, dataEntry, LockType.WRITE, true, false);
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var14_9 = null;
                        if (cursor != null) {
                            cursor.releaseBINs();
                            cursor.close();
                        }
                        if (locker == null) throw throwable;
                        ((Locker)locker).operationEnd();
                        throw throwable;
                    }
                }
                cursor.releaseBINs();
                cursor.close();
            }
            if (locker == null) return;
            ((Locker)locker).operationEnd();
            return;
        }
        Object var14_8 = null;
        if (cursor != null) {
            cursor.releaseBINs();
            cursor.close();
        }
        if (locker == null) return;
        ((Locker)locker).operationEnd();
    }

    public void flushFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (tfs.getAllowFlush()) {
            this.putFileSummary(tfs);
        }
    }

    private synchronized PackedOffsets putFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (this.env.isReadOnly()) {
            throw new DatabaseException("Cannot write file summary in a read-only environment");
        }
        if (tfs.isEmpty()) {
            return null;
        }
        if (!this.cachePopulated) {
            return null;
        }
        long fileNum = tfs.getFileNumber();
        Long fileNumLong = new Long(fileNum);
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(fileNumLong);
        if (summary == null) {
            File file = new File(this.env.getFileManager().getFullFileName(fileNum, ".jdb"));
            if (!file.exists()) {
                return null;
            }
            summary = new FileSummary();
        }
        FileSummary tmp = new FileSummary();
        tmp.add(summary);
        tmp.add(tfs);
        int sequence = tmp.getEntriesCounted();
        FileSummaryLN ln = new FileSummaryLN(summary);
        ln.setTrackedSummary(tfs);
        this.insertFileSummary(ln, fileNum, sequence);
        summary = ln.getBaseSummary();
        if (this.fileSummaryMap.put(fileNumLong, summary) == null) {
            MemoryBudget mb = this.env.getMemoryBudget();
            mb.updateMiscMemoryUsage(MemoryBudget.UTILIZATION_PROFILE_ENTRY);
        }
        return ln.getObsoleteOffsets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TrackedFileSummary getObsoleteDetail(Long fileNum, PackedOffsets packedOffsets, boolean logUpdate) throws DatabaseException {
        BasicLocker locker;
        TrackedFileSummary tfs;
        ArrayList<long[]> list;
        block19: {
            if (!this.env.getCleaner().trackDetail) {
                return null;
            }
            if (!$assertionsDisabled && !this.cachePopulated) {
                throw new AssertionError();
            }
            long fileNumVal = fileNum;
            list = new ArrayList<long[]>();
            tfs = this.env.getLogManager().getUnflushableTrackedSummary(fileNumVal);
            locker = null;
            CursorImpl cursor = null;
            try {
                locker = new BasicLocker(this.env);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry dataEntry = new DatabaseEntry();
                OperationStatus status = OperationStatus.SUCCESS;
                if (!this.getFirstFSLN(cursor, fileNumVal, keyEntry, dataEntry, LockType.NONE)) {
                    status = OperationStatus.NOTFOUND;
                }
                while (status == OperationStatus.SUCCESS) {
                    this.env.getEvictor().doCriticalEviction();
                    FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                    if (ln != null) {
                        if (fileNumVal != ln.getFileNumber(keyEntry.getData())) break;
                        PackedOffsets offsets = ln.getObsoleteOffsets();
                        if (offsets != null) {
                            list.add(offsets.toArray());
                        }
                        cursor.evict();
                    }
                    status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
                }
                Object var16_19 = null;
                if (cursor == null) break block19;
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                if (cursor != null) {
                    cursor.releaseBINs();
                    cursor.close();
                }
                if (locker != null) {
                    ((Locker)locker).operationEnd();
                }
                throw throwable;
            }
            cursor.releaseBINs();
            cursor.close();
        }
        if (locker != null) {
            ((Locker)locker).operationEnd();
        }
        if (!tfs.isEmpty()) {
            PackedOffsets offsets = null;
            if (logUpdate) {
                offsets = this.putFileSummary(tfs);
                if (offsets != null) {
                    list.add(offsets.toArray());
                }
            } else {
                long[] offsetList = tfs.getObsoleteOffsets();
                if (offsetList != null) {
                    list.add(offsetList);
                }
            }
        }
        int size = 0;
        for (int i = 0; i < list.size(); ++i) {
            long[] a = (long[])list.get(i);
            size += a.length;
        }
        long[] offsets = new long[size];
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            long[] a = (long[])list.get(i);
            System.arraycopy(a, 0, offsets, index, a.length);
            index += a.length;
        }
        if (!$assertionsDisabled && index != offsets.length) {
            throw new AssertionError();
        }
        packedOffsets.pack(offsets);
        return tfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateCache() throws DatabaseException {
        BasicLocker locker;
        int oldMemorySize;
        block18: {
            if (!$assertionsDisabled && this.cachePopulated) {
                throw new AssertionError();
            }
            if (!this.openFileSummaryDatabase()) {
                return false;
            }
            oldMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
            Object[] existingFiles = this.env.getFileManager().getAllFileNumbers();
            locker = null;
            CursorImpl cursor = null;
            try {
                locker = new BasicLocker(this.env);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry dataEntry = new DatabaseEntry();
                if (cursor.positionFirstOrLast(true, null)) {
                    OperationStatus status = cursor.getCurrentAlreadyLatched(keyEntry, dataEntry, LockType.NONE, true);
                    if (status != OperationStatus.SUCCESS) {
                        status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
                    }
                    while (status == OperationStatus.SUCCESS) {
                        this.env.getEvictor().doCriticalEviction();
                        FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                        if (ln == null) {
                            status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
                            continue;
                        }
                        byte[] keyBytes = keyEntry.getData();
                        boolean isOldVersion = ln.hasStringKey(keyBytes);
                        long fileNum = ln.getFileNumber(keyBytes);
                        Long fileNumLong = new Long(fileNum);
                        if (Arrays.binarySearch(existingFiles, fileNumLong) >= 0) {
                            this.fileSummaryMap.put(fileNumLong, ln.getBaseSummary());
                            if (isOldVersion) {
                                this.insertFileSummary(ln, fileNum, 0);
                                cursor.latchBIN();
                                cursor.delete();
                                cursor.releaseBIN();
                            } else {
                                cursor.evict();
                            }
                        } else {
                            this.fileSummaryMap.remove(fileNumLong);
                            if (isOldVersion) {
                                cursor.latchBIN();
                                cursor.delete();
                                cursor.releaseBIN();
                            } else {
                                this.deleteFileSummary(fileNumLong);
                            }
                        }
                        if (isOldVersion) {
                            status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false);
                            continue;
                        }
                        if (this.getFirstFSLN(cursor, fileNum + 1L, keyEntry, dataEntry, LockType.NONE)) continue;
                        status = OperationStatus.NOTFOUND;
                    }
                }
                Object var15_13 = null;
                if (cursor == null) break block18;
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                if (cursor != null) {
                    cursor.releaseBINs();
                    cursor.close();
                }
                if (locker != null) {
                    ((Locker)locker).operationEnd();
                }
                int newMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
                MemoryBudget mb = this.env.getMemoryBudget();
                mb.updateMiscMemoryUsage(newMemorySize - oldMemorySize);
                throw throwable;
            }
            cursor.releaseBINs();
            cursor.close();
        }
        if (locker != null) {
            ((Locker)locker).operationEnd();
        }
        int newMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
        MemoryBudget mb = this.env.getMemoryBudget();
        mb.updateMiscMemoryUsage(newMemorySize - oldMemorySize);
        this.cachePopulated = true;
        return true;
    }

    private boolean getFirstFSLN(CursorImpl cursor, long fileNum, DatabaseEntry keyEntry, DatabaseEntry dataEntry, LockType lockType) throws DatabaseException {
        boolean exactKeyMatch;
        byte[] keyBytes = FileSummaryLN.makePartialKey(fileNum);
        keyEntry.setData(keyBytes);
        int result = cursor.searchAndPosition(keyEntry, dataEntry, CursorImpl.SearchMode.SET_RANGE, lockType);
        if ((result & 1) == 0) {
            return false;
        }
        boolean bl = exactKeyMatch = (result & 2) != 0;
        if (exactKeyMatch && cursor.getCurrentAlreadyLatched(keyEntry, dataEntry, lockType, true) != OperationStatus.KEYEMPTY) {
            return true;
        }
        OperationStatus status = cursor.getNext(keyEntry, dataEntry, lockType, true, !exactKeyMatch);
        return status == OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openFileSummaryDatabase() throws DatabaseException {
        boolean bl;
        boolean operationOk;
        AutoTxn autoTxn;
        block6: {
            boolean bl2;
            block5: {
                if (this.fileSummaryDb != null) {
                    return true;
                }
                DbTree dbTree = this.env.getDbMapTree();
                autoTxn = null;
                operationOk = false;
                try {
                    autoTxn = new AutoTxn(this.env, new TransactionConfig());
                    DatabaseImpl db = dbTree.getDb(autoTxn, "_jeUtilization", null, true);
                    if (db == null) {
                        if (this.env.isReadOnly()) {
                            bl2 = false;
                            Object var7_7 = null;
                            if (autoTxn == null) return bl2;
                            break block5;
                        }
                        db = dbTree.createDb(autoTxn, "_jeUtilization", new DatabaseConfig(), null, true);
                    }
                    this.fileSummaryDb = db;
                    operationOk = true;
                    bl = true;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (autoTxn == null) throw throwable;
                    ((Locker)autoTxn).operationEnd(operationOk);
                    throw throwable;
                }
            }
            ((Locker)autoTxn).operationEnd(operationOk);
            return bl2;
        }
        Object var7_8 = null;
        if (autoTxn == null) return bl;
        ((Locker)autoTxn).operationEnd(operationOk);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void insertFileSummary(FileSummaryLN ln, long fileNum, int sequence) throws DatabaseException {
        BasicLocker locker;
        block6: {
            byte[] keyBytes = FileSummaryLN.makeFullKey(fileNum, sequence);
            locker = null;
            CursorImpl cursor = null;
            try {
                locker = new BasicLocker(this.env);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                cursor.setAllowEviction(false);
                OperationStatus status = cursor.putLN(keyBytes, ln, false);
                if (status == OperationStatus.KEYEXIST) {
                    this.env.getLogger().log(Level.SEVERE, "Cleaner duplicate key sequence file=0x" + Long.toHexString(fileNum) + " sequence=0x" + Long.toHexString(sequence));
                }
                cursor.evict();
                Object var10_8 = null;
                if (cursor == null) break block6;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (cursor != null) {
                    cursor.close();
                }
                if (locker != null) {
                    ((Locker)locker).operationEnd();
                }
                throw throwable;
            }
            cursor.close();
        }
        if (locker != null) {
            ((Locker)locker).operationEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyFileSummaryDatabase() throws DatabaseException {
        boolean ok;
        BasicLocker locker;
        block9: {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            this.openFileSummaryDatabase();
            locker = null;
            CursorImpl cursor = null;
            ok = true;
            try {
                locker = new BasicLocker(this.env);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                if (cursor.positionFirstOrLast(true, null)) {
                    OperationStatus status = cursor.getCurrentAlreadyLatched(key, data, LockType.NONE, true);
                    while (status == OperationStatus.SUCCESS) {
                        this.env.getEvictor().doCriticalEviction();
                        FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                        if (ln == null) continue;
                        long fileNumVal = ln.getFileNumber(key.getData());
                        PackedOffsets offsets = ln.getObsoleteOffsets();
                        if (offsets != null) {
                            long[] vals = offsets.toArray();
                            for (int i = 0; i < vals.length; ++i) {
                                long lsn = DbLsn.makeLsn(fileNumVal, vals[i]);
                                if (this.verifyLsnIsObsolete(lsn)) continue;
                                ok = false;
                            }
                        }
                        cursor.evict();
                        status = cursor.getNext(key, data, LockType.NONE, true, false);
                    }
                }
                Object var16_13 = null;
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (cursor != null) {
                    cursor.close();
                }
                if (locker != null) {
                    ((Locker)locker).operationEnd();
                }
                throw throwable;
            }
            cursor.close();
        }
        if (locker != null) {
            ((Locker)locker).operationEnd();
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyLsnIsObsolete(long lsn) throws DatabaseException {
        boolean bl;
        block14: {
            IN bin;
            block12: {
                boolean bl2;
                block13: {
                    int index;
                    block10: {
                        boolean bl3;
                        block11: {
                            block8: {
                                boolean bl4;
                                block9: {
                                    LogEntry o = this.env.getLogManager().getLogEntry(lsn);
                                    if (!(o instanceof LNLogEntry)) {
                                        return true;
                                    }
                                    LNLogEntry entry = (LNLogEntry)o;
                                    if (entry.getLN().isDeleted()) {
                                        return true;
                                    }
                                    DatabaseId dbId = entry.getDbId();
                                    DatabaseImpl db = this.env.getDbMapTree().getDb(dbId);
                                    if (db == null || db.isDeleted()) {
                                        return true;
                                    }
                                    bin = null;
                                    try {
                                        Tree tree = db.getTree();
                                        TreeLocation location = new TreeLocation();
                                        boolean parentFound = tree.getParentBINForChildLN(location, entry.getKey(), entry.getDupKey(), entry.getLN(), false, true, false, false);
                                        bin = location.bin;
                                        index = location.index;
                                        if (parentFound) break block8;
                                        bl4 = true;
                                        Object var14_15 = null;
                                        if (bin == null) break block9;
                                    }
                                    catch (Throwable throwable) {
                                        block15: {
                                            Object var14_19 = null;
                                            if (bin == null) break block15;
                                            bin.releaseLatch();
                                        }
                                        throw throwable;
                                    }
                                    bin.releaseLatch();
                                }
                                return bl4;
                            }
                            if (!bin.isEntryKnownDeleted(index)) break block10;
                            bl3 = true;
                            Object var14_16 = null;
                            if (bin == null) break block11;
                            bin.releaseLatch();
                        }
                        return bl3;
                    }
                    if (bin.getLsn(index) == lsn) break block12;
                    bl2 = true;
                    Object var14_17 = null;
                    if (bin == null) break block13;
                    bin.releaseLatch();
                }
                return bl2;
            }
            System.err.println("lsn " + DbLsn.getNoFormatString(lsn) + " was found in tree.");
            bl = false;
            Object var14_18 = null;
            if (bin == null) break block14;
            bin.releaseLatch();
        }
        return bl;
    }

    static {
        $assertionsDisabled = !UtilizationProfile.class.desiredAssertionStatus();
    }
}

