/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.tree.IN;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class INList {
    private static final String DEBUG_NAME;
    private SortedSet ins = null;
    private Set addedINs = null;
    private EnvironmentImpl envImpl;
    private Latch majorLatch;
    private Latch minorLatch;
    private boolean updateMemoryUsage;
    static final /* synthetic */ boolean $assertionsDisabled;

    INList(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.ins = new TreeSet();
        this.addedINs = new HashSet();
        this.majorLatch = LatchSupport.makeLatch(DEBUG_NAME + " Major Latch", envImpl);
        this.minorLatch = LatchSupport.makeLatch(DEBUG_NAME + " Minor Latch", envImpl);
        this.updateMemoryUsage = true;
    }

    public INList(INList orig, EnvironmentImpl envImpl) throws DatabaseException {
        this.ins = new TreeSet(orig.getINs());
        this.addedINs = new HashSet();
        this.envImpl = envImpl;
        this.majorLatch = LatchSupport.makeLatch(DEBUG_NAME + " Major Latch", envImpl);
        this.minorLatch = LatchSupport.makeLatch(DEBUG_NAME + " Minor Latch", envImpl);
        this.updateMemoryUsage = false;
    }

    public SortedSet getINs() {
        return this.ins;
    }

    public int getSize() {
        return this.ins.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IN in) throws DatabaseException {
        block14: {
            boolean enteredWithLatchHeld = this.majorLatch.isOwner();
            boolean addToMajor = true;
            try {
                if (enteredWithLatchHeld) {
                    addToMajor = false;
                } else if (!this.majorLatch.acquireNoWait()) {
                    addToMajor = false;
                }
                if (addToMajor) {
                    this.addAndSetMemory(this.ins, in);
                    break block14;
                }
                this.minorLatch.acquire();
                try {
                    this.addAndSetMemory(this.addedINs, in);
                }
                finally {
                    this.minorLatch.release();
                }
                if (enteredWithLatchHeld || !this.majorLatch.acquireNoWait()) break block14;
                try {
                    this.latchMinorAndDumpAddedINs();
                }
                finally {
                    this.releaseMajorLatch();
                }
            }
            finally {
                if (addToMajor) {
                    this.releaseMajorLatchIfHeld();
                }
            }
        }
    }

    private void addAndSetMemory(Set set, IN in) {
        boolean addOk = set.add(in);
        if (!$assertionsDisabled && !addOk) {
            throw new AssertionError((Object)("failed adding in " + in.getNodeId()));
        }
        if (this.updateMemoryUsage) {
            MemoryBudget mb = this.envImpl.getMemoryBudget();
            mb.updateTreeMemoryUsage(in.getInMemorySize());
            in.setInListResident(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLatchAlreadyHeld(IN in) throws DatabaseException {
        if (!$assertionsDisabled && !this.majorLatch.isOwner()) {
            throw new AssertionError();
        }
        boolean removeDone = this.ins.remove(in);
        if (!removeDone) {
            this.minorLatch.acquire();
            try {
                removeDone = this.addedINs.remove(in);
                this.dumpAddedINsIntoMajorSet();
            }
            finally {
                this.minorLatch.release();
            }
        }
        if (!$assertionsDisabled && !removeDone) {
            throw new AssertionError();
        }
        if (this.updateMemoryUsage) {
            this.envImpl.getMemoryBudget().updateTreeMemoryUsage((long)in.getAccumulatedDelta() - in.getInMemorySize());
            in.setInListResident(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IN in) throws DatabaseException {
        if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        this.majorLatch.acquire();
        try {
            this.removeLatchAlreadyHeld(in);
        }
        finally {
            this.releaseMajorLatch();
        }
    }

    public SortedSet tailSet(IN in) throws DatabaseException {
        if (!$assertionsDisabled && !this.majorLatch.isOwner()) {
            throw new AssertionError();
        }
        return this.ins.tailSet(in);
    }

    public IN first() throws DatabaseException {
        if (!$assertionsDisabled && !this.majorLatch.isOwner()) {
            throw new AssertionError();
        }
        return (IN)this.ins.first();
    }

    public Iterator iterator() {
        if (!$assertionsDisabled && !this.majorLatch.isOwner()) {
            throw new AssertionError();
        }
        return this.ins.iterator();
    }

    public void clear() throws DatabaseException {
        if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        this.majorLatch.acquire();
        this.minorLatch.acquire();
        this.ins.clear();
        this.addedINs.clear();
        this.minorLatch.release();
        this.releaseMajorLatch();
        if (this.updateMemoryUsage) {
            this.envImpl.getMemoryBudget().refreshTreeMemoryUsage(0L);
        }
    }

    public void dump() {
        System.out.println("size=" + this.getSize());
        Iterator iter = this.ins.iterator();
        while (iter.hasNext()) {
            IN theIN = (IN)iter.next();
            System.out.println("db=" + theIN.getDatabase().getId() + " nid=: " + theIN.getNodeId() + "/" + theIN.getLevel());
        }
    }

    public void latchMajor() throws DatabaseException {
        if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        this.majorLatch.acquire();
    }

    public void releaseMajorLatchIfHeld() throws DatabaseException {
        if (this.majorLatch.isOwner()) {
            this.releaseMajorLatch();
        }
    }

    public void releaseMajorLatch() throws DatabaseException {
        this.latchMinorAndDumpAddedINs();
        this.majorLatch.release();
    }

    private void dumpAddedINsIntoMajorSet() {
        if (this.addedINs.size() > 0) {
            this.ins.addAll(this.addedINs);
            this.addedINs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void latchMinorAndDumpAddedINs() throws DatabaseException {
        this.latchMinor();
        try {
            this.dumpAddedINsIntoMajorSet();
        }
        finally {
            this.releaseMinorLatch();
        }
    }

    private void latchMinor() throws DatabaseException {
        this.minorLatch.acquire();
    }

    private void releaseMinorLatch() throws DatabaseException {
        this.minorLatch.release();
    }

    static {
        $assertionsDisabled = !INList.class.desiredAssertionStatus();
        DEBUG_NAME = INList.class.getName();
    }
}

