/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.model;

import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.raw.RawType;
import java.util.Collections;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class EntityModel {
    private PersistCatalog catalog;

    protected EntityModel() {
    }

    public final void registerClass(Class persistentClass) {
        if (this.catalog != null) {
            throw new IllegalStateException("Store is already open");
        }
        String className = persistentClass.getName();
        ClassMetadata meta = this.getClassMetadata(className);
        if (meta == null) {
            throw new IllegalArgumentException("Class is not persistent: " + className);
        }
    }

    void setCatalog(PersistCatalog catalog) {
        this.catalog = catalog;
    }

    public abstract ClassMetadata getClassMetadata(String var1);

    public abstract EntityMetadata getEntityMetadata(String var1);

    public abstract Set<String> getKnownClasses();

    public final RawType getRawType(String className) {
        if (this.catalog != null) {
            return this.catalog.getFormat(className);
        }
        throw new IllegalStateException("Store is not open");
    }

    public final SortedMap<Integer, RawType> getAllRawTypes(String className) {
        if (this.catalog != null) {
            Format type = this.catalog.getFormat(className);
            if (type != null) {
                TreeMap<Integer, Format> map = new TreeMap<Integer, Format>();
                map.put(0, type);
                return Collections.unmodifiableSortedMap(map);
            }
            return null;
        }
        throw new IllegalStateException("Store is not open");
    }
}

