/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.remoting;

import java.io.IOException;
import java.io.Serializable;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.util.PayloadKey;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.logging.Logger;
import org.jboss.serial.io.MarshalledObjectForLocalCalls;

public class IsLocalInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 337700910587744646L;
    private static final Logger log = Logger.getLogger(IsLocalInterceptor.class);
    public static final String GUID = "GUID";
    public static final String IS_LOCAL = "IS_LOCAL";
    public static final String IS_LOCAL_EXCEPTION = "IS_LOCAL_EXCEPTION";
    private static boolean passByRef = Boolean.getBoolean(IsLocalInterceptor.class.getName() + ".passByRef");
    private static final long stamp = System.currentTimeMillis();
    private long marshalledStamp = stamp;

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.isLocal()) {
            String guid = (String)invocation.getMetaData((Object)IS_LOCAL, (Object)GUID);
            Container container = Ejb3Registry.getContainer(guid);
            return this.invokeLocal(invocation, container);
        }
        return invocation.invokeNext();
    }

    protected Object invokeLocal(Invocation invocation, Container container) throws Throwable {
        Invocation copy = IsLocalInterceptor.marshallOrPass(invocation, Invocation.class);
        copy.getMetaData().addMetaData((Object)IS_LOCAL, (Object)IS_LOCAL, (Object)Boolean.TRUE, PayloadKey.AS_IS);
        try {
            SessionContainer sc = (SessionContainer)container;
            InvocationResponse response = sc.dynamicInvoke(copy);
            invocation.setResponseContextInfo(response.getContextInfo());
            Object object = IsLocalInterceptor.marshallOrPass(response.getResponse(), Object.class);
            return object;
        }
        catch (Throwable t) {
            throw IsLocalInterceptor.marshallOrPass(t, Throwable.class);
        }
        finally {
            copy.getMetaData().removeMetaData((Object)IS_LOCAL, (Object)IS_LOCAL);
        }
    }

    protected boolean isLocal() {
        return stamp == this.marshalledStamp;
    }

    private static <T> T marshallOrPass(T obj, Class<T> type) throws IOException, ClassNotFoundException {
        if (passByRef) {
            return obj;
        }
        return type.cast(new MarshalledObjectForLocalCalls(obj).get());
    }
}

