/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra.recovery;

import java.util.Set;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.server.recovery.HornetQRegistryBase;
import org.hornetq.jms.server.recovery.XARecoveryConfig;
import org.hornetq.ra.Util;
import org.hornetq.utils.ConcurrentHashSet;
import org.jboss.tm.XAResourceRecoveryRegistry;

public class RecoveryManager {
    private static Logger log = Logger.getLogger(RecoveryManager.class);
    private HornetQRegistryBase registry;
    private String resourceRecoveryClassNames = "org.jboss.as.integration.hornetq.recovery.AS5RecoveryRegistry";
    private final Set<XARecoveryConfig> resources = new ConcurrentHashSet();

    public void start(boolean useAutoRecovery) {
        if (useAutoRecovery) {
            this.locateRecoveryRegistry();
        } else {
            this.registry = new EmptyRecoveryRegistry();
        }
    }

    public XARecoveryConfig register(HornetQConnectionFactory factory, String userName, String password) {
        log.debug((Object)("registering recovery for factory : " + factory));
        XARecoveryConfig config = this.newResourceConfig(factory, userName, password);
        this.resources.add(config);
        if (this.registry != null) {
            this.registry.register(config);
        }
        return config;
    }

    private XARecoveryConfig newResourceConfig(HornetQConnectionFactory factory, String userName, String password) {
        if (factory.getServerLocator().getDiscoveryGroupConfiguration() != null) {
            return new XARecoveryConfig(factory.getServerLocator().isHA(), factory.getServerLocator().getDiscoveryGroupConfiguration(), userName, password);
        }
        return new XARecoveryConfig(factory.getServerLocator().isHA(), factory.getServerLocator().getStaticTransportConfigurations(), userName, password);
    }

    public void unRegister(XARecoveryConfig resourceRecovery) {
        this.registry.unRegister(resourceRecovery);
    }

    public void stop() {
        for (XARecoveryConfig recovery : this.resources) {
            this.registry.unRegister(recovery);
        }
        this.resources.clear();
    }

    private void locateRecoveryRegistry() {
        String[] locatorClasses = this.resourceRecoveryClassNames.split(";");
        for (int i = 0; i < locatorClasses.length; ++i) {
            try {
                this.registry = Util.locateRecoveryRegistry(locatorClasses[i]);
            }
            catch (Throwable e) {
                log.debug((Object)("unable to load  recovery registry " + locatorClasses[i]), e);
            }
            if (this.registry != null) break;
        }
        if (this.registry == null) {
            this.registry = new EmptyRecoveryRegistry();
        } else {
            log.debug((Object)("Recovery Registry located = " + this.registry));
        }
    }

    private static class EmptyRecoveryRegistry
    extends HornetQRegistryBase {
        private EmptyRecoveryRegistry() {
        }

        public XAResourceRecoveryRegistry getTMRegistry() {
            return null;
        }

        public void register(XARecoveryConfig resourceConfig) {
        }

        public void unRegister(XARecoveryConfig resourceConfig) {
        }
    }
}

