/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.apps;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.helpers.Debug;
import org.apache.xml.resolver.tools.CatalogResolver;

public class resolver {
    private static Debug debug = CatalogManager.getStaticManager().debug;

    public static void main(String[] stringArray) throws FileNotFoundException, IOException {
        String string;
        Object object;
        int n = 0;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-c")) {
                vector.add(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-p")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-s")) {
                string5 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-n")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-u")) {
                string6 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-a")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-d")) {
                object = stringArray[++i];
                try {
                    n = Integer.parseInt((String)object);
                    if (n <= 0) continue;
                    debug.setDebug(n);
                }
                catch (Exception exception) {}
                continue;
            }
            string2 = stringArray[i];
        }
        if (string2 == null) {
            resolver.usage();
        }
        if (string2.equalsIgnoreCase("doctype")) {
            n2 = Catalog.DOCTYPE;
            if (string4 == null && string5 == null) {
                System.out.println("DOCTYPE requires public or system identifier.");
                resolver.usage();
            }
        } else if (string2.equalsIgnoreCase("document")) {
            n2 = Catalog.DOCUMENT;
        } else if (string2.equalsIgnoreCase("entity")) {
            n2 = Catalog.ENTITY;
            if (string4 == null && string5 == null && string3 == null) {
                System.out.println("ENTITY requires name or public or system identifier.");
                resolver.usage();
            }
        } else if (string2.equalsIgnoreCase("notation")) {
            n2 = Catalog.NOTATION;
            if (string4 == null && string5 == null && string3 == null) {
                System.out.println("NOTATION requires name or public or system identifier.");
                resolver.usage();
            }
        } else if (string2.equalsIgnoreCase("public")) {
            n2 = Catalog.PUBLIC;
            if (string4 == null) {
                System.out.println("PUBLIC requires public identifier.");
                resolver.usage();
            }
        } else if (string2.equalsIgnoreCase("system")) {
            n2 = Catalog.SYSTEM;
            if (string5 == null) {
                System.out.println("SYSTEM requires system identifier.");
                resolver.usage();
            }
        } else if (string2.equalsIgnoreCase("uri")) {
            n2 = Catalog.URI;
            if (string6 == null) {
                System.out.println("URI requires a uri.");
                resolver.usage();
            }
        } else {
            System.out.println(string2 + " is not a recognized keyword.");
            resolver.usage();
        }
        if (bl) {
            URL uRL = null;
            object = null;
            try {
                String string7 = System.getProperty("user.dir");
                string7.replace('\\', '/');
                uRL = new File("basename").toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                string = System.getProperty("user.dir");
                string.replace('\\', '/');
                debug.message(1, "Malformed URL on cwd", string);
                uRL = null;
            }
            try {
                object = new URL(uRL, string5);
                string5 = ((URL)object).toString();
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    object = new File(string5).toURI().toURL();
                }
                catch (MalformedURLException malformedURLException2) {
                    debug.message(1, "Malformed URL on system id", string5);
                }
            }
        }
        CatalogResolver catalogResolver = new CatalogResolver();
        object = catalogResolver.getCatalog();
        for (int i = 0; i < vector.size(); ++i) {
            string = (String)vector.elementAt(i);
            ((Catalog)object).parseCatalog(string);
        }
        String string8 = null;
        if (n2 == Catalog.DOCTYPE) {
            System.out.println("Resolve DOCTYPE (name, publicid, systemid):");
            if (string3 != null) {
                System.out.println("       name: " + string3);
            }
            if (string4 != null) {
                System.out.println("  public id: " + string4);
            }
            if (string5 != null) {
                System.out.println("  system id: " + string5);
            }
            if (string6 != null) {
                System.out.println("        uri: " + string6);
            }
            string8 = ((Catalog)object).resolveDoctype(string3, string4, string5);
        } else if (n2 == Catalog.DOCUMENT) {
            System.out.println("Resolve DOCUMENT ():");
            string8 = ((Catalog)object).resolveDocument();
        } else if (n2 == Catalog.ENTITY) {
            System.out.println("Resolve ENTITY (name, publicid, systemid):");
            if (string3 != null) {
                System.out.println("       name: " + string3);
            }
            if (string4 != null) {
                System.out.println("  public id: " + string4);
            }
            if (string5 != null) {
                System.out.println("  system id: " + string5);
            }
            string8 = ((Catalog)object).resolveEntity(string3, string4, string5);
        } else if (n2 == Catalog.NOTATION) {
            System.out.println("Resolve NOTATION (name, publicid, systemid):");
            if (string3 != null) {
                System.out.println("       name: " + string3);
            }
            if (string4 != null) {
                System.out.println("  public id: " + string4);
            }
            if (string5 != null) {
                System.out.println("  system id: " + string5);
            }
            string8 = ((Catalog)object).resolveNotation(string3, string4, string5);
        } else if (n2 == Catalog.PUBLIC) {
            System.out.println("Resolve PUBLIC (publicid, systemid):");
            if (string4 != null) {
                System.out.println("  public id: " + string4);
            }
            if (string5 != null) {
                System.out.println("  system id: " + string5);
            }
            string8 = ((Catalog)object).resolvePublic(string4, string5);
        } else if (n2 == Catalog.SYSTEM) {
            System.out.println("Resolve SYSTEM (systemid):");
            if (string5 != null) {
                System.out.println("  system id: " + string5);
            }
            string8 = ((Catalog)object).resolveSystem(string5);
        } else if (n2 == Catalog.URI) {
            System.out.println("Resolve URI (uri):");
            if (string6 != null) {
                System.out.println("        uri: " + string6);
            }
            string8 = ((Catalog)object).resolveURI(string6);
        } else {
            System.out.println("resType is wrong!? This can't happen!");
            resolver.usage();
        }
        System.out.println("Result: " + string8);
    }

    public static void usage() {
        System.out.println("Usage: resolver [options] keyword");
        System.out.println("");
        System.out.println("Where:");
        System.out.println("");
        System.out.println("-c catalogfile  Loads a particular catalog file.");
        System.out.println("-n name         Sets the name.");
        System.out.println("-p publicId     Sets the public identifier.");
        System.out.println("-s systemId     Sets the system identifier.");
        System.out.println("-a              Makes the system URI absolute before resolution");
        System.out.println("-u uri          Sets the URI.");
        System.out.println("-d integer      Set the debug level.");
        System.out.println("keyword         Identifies the type of resolution to perform:");
        System.out.println("                doctype, document, entity, notation, public, system,");
        System.out.println("                or uri.");
        System.exit(1);
    }
}

