/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.values;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.values.AbstractMetaValue;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.MetaValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayValueSupport
extends AbstractMetaValue
implements ArrayValue {
    private static final long serialVersionUID = 1131827130033538066L;
    private ArrayMetaType metaType;
    private Object value;

    public ArrayValueSupport(ArrayMetaType metaType) {
        if (metaType == null) {
            throw new IllegalArgumentException("Null array meta type");
        }
        this.metaType = metaType;
    }

    public ArrayValueSupport(ArrayMetaType metaType, Object value) {
        this(metaType);
        this.value = value;
    }

    @Override
    public ArrayMetaType getMetaType() {
        return this.metaType;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public int getLength() {
        return Array.getLength(this.value);
    }

    @Override
    public Object getValue(int index) {
        return Array.get(this.value, index);
    }

    @Override
    public Iterator<Object> iterator() {
        return new ArrayValueIterator(this.value);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ArrayValue)) {
            return false;
        }
        ArrayValue other = (ArrayValue)obj;
        if (!this.metaType.equals(other.getMetaType())) {
            return false;
        }
        Object otherValue = other.getValue();
        if (this.value == null && otherValue == null) {
            return true;
        }
        if (this.value == null && otherValue != null) {
            return false;
        }
        boolean equals = false;
        equals = this.value instanceof Object[] && otherValue instanceof Object[] ? Arrays.deepEquals((Object[])this.value, (Object[])otherValue) : (this.value instanceof byte[] && otherValue instanceof byte[] ? Arrays.equals((byte[])this.value, (byte[])otherValue) : (this.value instanceof short[] && otherValue instanceof short[] ? Arrays.equals((short[])this.value, (short[])otherValue) : (this.value instanceof int[] && otherValue instanceof int[] ? Arrays.equals((int[])this.value, (int[])otherValue) : (this.value instanceof long[] && otherValue instanceof long[] ? Arrays.equals((long[])this.value, (long[])otherValue) : (this.value instanceof char[] && otherValue instanceof char[] ? Arrays.equals((char[])this.value, (char[])otherValue) : (this.value instanceof float[] && otherValue instanceof float[] ? Arrays.equals((float[])this.value, (float[])otherValue) : (this.value instanceof double[] && otherValue instanceof double[] ? Arrays.equals((double[])this.value, (double[])otherValue) : (this.value instanceof boolean[] && otherValue instanceof boolean[] ? Arrays.equals((boolean[])this.value, (boolean[])otherValue) : this.value.equals(otherValue)))))))));
        return equals;
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.metaType + ":" + this.deepToString();
    }

    @Override
    public MetaValue clone() {
        ArrayValueSupport result = (ArrayValueSupport)super.clone();
        int length = this.getLength();
        if (this.value != null && length > 0) {
            result.value = new Object[length];
            System.arraycopy(this.value, 0, result.value, 0, length);
        }
        return result;
    }

    protected String deepToString() {
        String deepToString = this.value == null ? "null" : (this.value instanceof byte[] ? Arrays.toString((byte[])this.value) : (this.value instanceof short[] ? Arrays.toString((short[])this.value) : (this.value instanceof int[] ? Arrays.toString((int[])this.value) : (this.value instanceof long[] ? Arrays.toString((long[])this.value) : (this.value instanceof char[] ? Arrays.toString((char[])this.value) : (this.value instanceof float[] ? Arrays.toString((float[])this.value) : (this.value instanceof double[] ? Arrays.toString((double[])this.value) : (this.value instanceof boolean[] ? Arrays.toString((boolean[])this.value) : (this.value instanceof Object[] ? Arrays.deepToString((Object[])this.value) : this.value.toString())))))))));
        return deepToString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayValueIterator
    implements Iterator<Object> {
        private int index;
        private int length;
        private Object array;

        ArrayValueIterator(Object array) {
            this.array = array;
            this.index = 0;
            this.length = Array.getLength(array);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public Object next() {
            return Array.get(this.array, this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

