/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.values;

import java.io.Serializable;
import org.jboss.metatype.api.types.GenericMetaType;
import org.jboss.metatype.api.values.AbstractMetaValue;
import org.jboss.metatype.api.values.GenericValue;

public class GenericValueSupport
extends AbstractMetaValue
implements GenericValue {
    private static final long serialVersionUID = 5552880928848272037L;
    private GenericMetaType metaType;
    private Serializable value;

    public GenericValueSupport(GenericMetaType metaType, Serializable value) {
        if (metaType == null) {
            throw new IllegalArgumentException("Null generic meta type");
        }
        this.metaType = metaType;
        this.value = value;
    }

    public GenericMetaType getMetaType() {
        return this.metaType;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof GenericValue)) {
            return false;
        }
        GenericValue other = (GenericValue)obj;
        if (!this.metaType.equals(other.getMetaType())) {
            return false;
        }
        Serializable otherValue = other.getValue();
        if (this.value == null && otherValue == null) {
            return true;
        }
        if (this.value == null && otherValue != null) {
            return false;
        }
        return this.value.equals(otherValue);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.metaType + ":" + this.value;
    }
}

