/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.endpoint.deployers;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.endpoint.deployers.EJBIdentifier;
import org.jboss.logging.Logger;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;

public class DefaultEJBIdentifier
implements EJBIdentifier {
    private static final Logger log = Logger.getLogger(DefaultEJBIdentifier.class);

    @Override
    public String identifyEJB(DeploymentUnit unit, String ejbName) {
        boolean isEar;
        StringBuilder containerName = new StringBuilder("jboss.j2ee:service=EJB3,");
        DeploymentUnit toplevelUnit = unit.getTopLevel();
        boolean bl = isEar = unit != unit.getTopLevel() || toplevelUnit.isAttachmentPresent(JBossAppMetaData.class);
        if (isEar) {
            containerName.append("ear=");
            containerName.append(toplevelUnit.getSimpleName());
            containerName.append(",");
        }
        if (unit.getSimpleName() == null) {
            containerName.append("*");
        } else {
            containerName.append("jar=");
            containerName.append(unit.getSimpleName());
        }
        containerName.append(",name=");
        containerName.append(ejbName);
        log.debug((Object)("Container name generated for ejb = " + ejbName + " in unit " + unit + " is " + containerName));
        try {
            ObjectName containerJMXName = new ObjectName(containerName.toString());
            return containerJMXName.getCanonicalName();
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }
}

