/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform.content.yum;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.plugins.platform.content.yum.Content;
import org.rhq.plugins.platform.content.yum.Primary;
import org.rhq.plugins.platform.content.yum.Request;

public class Package
extends Content {
    private PackageDetailsKey packageKey;

    public Package(Request request) {
        super(request);
        this.packageKey = Primary.toKey(request.args);
    }

    public long length() throws Exception {
        long result = 0L;
        long[] range = this.byteRange();
        result = range != null ? range[1] - range[0] + 1L : this.context().getPackageBitsLength(this.packageKey);
        return result;
    }

    public InputStream openStream() throws Exception {
        return null;
    }

    public void writeHeader(OutputStream ostr) throws Exception {
        PrintWriter writer = new PrintWriter(ostr);
        writer.printf("HTTP/1.1 200\n", new Object[0]);
        writer.println("Server: Ackbar (Red Hat)");
        writer.printf("Content-Length: %d\n\n", this.length());
        writer.flush();
        ostr.flush();
    }

    public void writeContent(OutputStream ostr) throws Exception {
        long[] range = this.byteRange();
        if (range != null) {
            this.context().writePackageBits(this.packageKey, range, ostr);
        } else {
            this.context().writePackageBits(this.packageKey, ostr);
        }
    }

    private long[] byteRange() {
        long[] result = null;
        String range = this.request.fields.get("Range");
        if (range != null) {
            String[] bytes = range.split("=")[1].split("-");
            result = new long[]{Long.valueOf(bytes[0]), Long.valueOf(bytes[1])};
        }
        return result;
    }
}

