/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import org.apache.ws.jaxme.xs.XSAnnotation;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.impl.XSOpenAttrsImpl;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsAnyURI;
import org.apache.ws.jaxme.xs.xml.XsBlockSet;
import org.apache.ws.jaxme.xs.xml.XsEAnnotation;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsFormChoice;
import org.apache.ws.jaxme.xs.xml.XsNCName;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.apache.ws.jaxme.xs.xml.XsTElement;
import org.apache.ws.jaxme.xs.xml.XsTTopLevelElement;
import org.xml.sax.SAXException;

public class XSElementImpl
extends XSOpenAttrsImpl
implements XSElement {
    private final XsQName name;
    private final XsEAnnotation xsAnnotation;
    private final boolean isGlobal;
    private XSAnnotation[] annotations;
    private boolean isValidated;
    private XSType type;
    private XSGroup substitutionGroup;

    protected XsTElement getXsTElement() {
        return (XsTElement)this.getXsObject();
    }

    protected boolean isReference() {
        return this.getXsTElement().getRef() != null;
    }

    protected boolean isInnerSimpleType() {
        return this.getXsTElement().getSimpleType() != null;
    }

    protected boolean isInnerComplexType() {
        return this.getXsTElement().getComplexType() != null;
    }

    protected XSElementImpl(XSObject pParent, XsTElement pBaseElement) throws SAXException {
        super(pParent, pBaseElement);
        XsQName qName;
        if (this.isReference()) {
            qName = pBaseElement.getRef();
        } else {
            String namespacePrefix;
            XsAnyURI namespace;
            XsNCName myName = pBaseElement.getName();
            if (myName == null) {
                throw new LocSAXException("Invalid element: Must have either of its 'ref' or 'name' attributes set.", this.getLocator());
            }
            XsESchema schema = pBaseElement.getXsESchema();
            boolean qualified = pBaseElement.isGlobal();
            if (!qualified) {
                XsFormChoice form = pBaseElement.getForm();
                if (form == null) {
                    form = schema.getElementFormDefault();
                }
                qualified = XsFormChoice.QUALIFIED.equals(form);
            }
            if (qualified) {
                namespace = schema.getTargetNamespace();
                namespacePrefix = schema.getTargetNamespacePrefix();
            } else {
                namespace = null;
                namespacePrefix = null;
            }
            qName = new XsQName(namespace, myName.toString(), namespacePrefix);
        }
        this.name = qName;
        this.xsAnnotation = pBaseElement.getAnnotation();
        this.isGlobal = pBaseElement instanceof XsTTopLevelElement;
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    @Override
    public XsQName getName() {
        return this.name;
    }

    @Override
    public XSType getType() {
        return this.type;
    }

    protected boolean isValidated() {
        return this.isValidated;
    }

    @Override
    public void validate() throws SAXException {
        XSType myType;
        if (this.isValidated()) {
            return;
        }
        this.isValidated = true;
        if (this.xsAnnotation == null) {
            this.annotations = new XSAnnotation[0];
        } else {
            XSAnnotation result = this.getXSSchema().getXSObjectFactory().newXSAnnotation(this, this.xsAnnotation);
            result.validate();
            this.annotations = new XSAnnotation[]{result};
        }
        if (this.isReference()) {
            XSElement element = this.getXSSchema().getElement(this.getName());
            if (element == null) {
                throw new LocSAXException("Invalid element reference: " + this.getName() + " is not defined.", this.getLocator());
            }
            element.validate();
            myType = element.getType();
        } else {
            XsTElement element = this.getXsTElement();
            if (this.isInnerSimpleType()) {
                myType = this.getXSSchema().getXSObjectFactory().newXSType((XSObject)this, element.getSimpleType());
            } else if (this.isInnerComplexType()) {
                myType = this.getXSSchema().getXSObjectFactory().newXSType((XSObject)this, element.getComplexType());
            } else {
                XsQName typeName = element.getType();
                if (typeName == null) {
                    throw new LocSAXException("Invalid element: Either of its 'type' or 'ref' attributes or its 'simpleType' or 'complexType' children must be set.", this.getLocator());
                }
                myType = this.getXSSchema().getType(typeName);
                if (myType == null) {
                    throw new LocSAXException("Invalid element: The type " + typeName + " is not defined.", this.getLocator());
                }
            }
        }
        this.type = myType;
        myType.validate();
    }

    @Override
    public XSAnnotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getDefault() {
        return this.getXsTElement().getDefault();
    }

    @Override
    public String getFixed() {
        return this.getXsTElement().getFixed();
    }

    @Override
    public XsQName getSubstitutionGroupName() {
        return this.getXsTElement().getSubstitutionGroup();
    }

    @Override
    public boolean isBlockedForSubstitution() {
        XsBlockSet blockSet = this.getXsTElement().getBlock();
        if (blockSet == null) {
            blockSet = this.getXsTElement().getXsESchema().getBlockDefault();
        }
        return !blockSet.isSubstitutionAllowed();
    }

    @Override
    public boolean isAbstract() {
        return this.getXsTElement().getAbstract();
    }

    @Override
    public void setSubstitutionGroup(XSGroup pGroup) {
        this.substitutionGroup = pGroup;
    }

    @Override
    public XSGroup getSubstitutionGroup() {
        return this.substitutionGroup;
    }
}

