/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import org.apache.ws.jaxme.xs.XSAny;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSParticle;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XSParticleImpl
implements XSParticle {
    private final XSGroup group;
    private final XSAny wildcard;
    private final XSElement element;
    private int minOccurs = 1;
    private int maxOccurs = 1;

    public XSParticleImpl(XSGroup pGroup) throws SAXException {
        if (pGroup == null) {
            throw new NullPointerException("The particle group must not be null.");
        }
        this.group = pGroup;
        this.element = null;
        this.wildcard = null;
    }

    public XSParticleImpl(XSAny pWildcard) {
        if (pWildcard == null) {
            throw new NullPointerException("The particle wildcard must not be null.");
        }
        this.wildcard = pWildcard;
        this.group = null;
        this.element = null;
    }

    public XSParticleImpl(XSElement pElement) {
        if (pElement == null) {
            throw new NullPointerException("The particle element must not be null.");
        }
        this.element = pElement;
        this.group = null;
        this.wildcard = null;
    }

    @Override
    public XSParticle.Type getType() {
        if (this.group != null) {
            return XSParticle.GROUP;
        }
        if (this.wildcard != null) {
            return XSParticle.WILDCARD;
        }
        if (this.element != null) {
            return XSParticle.ELEMENT;
        }
        throw new IllegalStateException("Neither of the particle group, wildcard, or element has been set.");
    }

    @Override
    public boolean isGroup() {
        return this.group != null;
    }

    @Override
    public XSGroup getGroup() {
        if (this.group == null) {
            throw new IllegalStateException("This particle doesn't have the group type.");
        }
        return this.group;
    }

    @Override
    public boolean isWildcard() {
        return this.wildcard != null;
    }

    @Override
    public XSAny getWildcard() {
        if (this.wildcard == null) {
            throw new IllegalStateException("This particle doesn't have the wildcard type.");
        }
        return this.wildcard;
    }

    @Override
    public boolean isElement() {
        return this.element != null;
    }

    @Override
    public XSElement getElement() {
        if (this.element == null) {
            throw new IllegalStateException("This particle doesn't have the element type.");
        }
        return this.element;
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int pMinOccurs) {
        this.minOccurs = pMinOccurs;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int pMaxOccurs) {
        this.maxOccurs = pMaxOccurs;
    }

    @Override
    public Locator getLocator() {
        if (this.isWildcard()) {
            return this.getWildcard().getLocator();
        }
        if (this.isElement()) {
            return this.getElement().getLocator();
        }
        if (this.isGroup()) {
            return this.getGroup().getLocator();
        }
        throw new IllegalStateException("Invalid particle, neither of element, wildcard, or model group.");
    }
}

