/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.TimeZone;

public class XsDateTimeFormat
extends Format {
    final boolean parseDate;
    final boolean parseTime;

    XsDateTimeFormat(boolean pParseDate, boolean pParseTime) {
        this.parseDate = pParseDate;
        this.parseTime = pParseTime;
    }

    public XsDateTimeFormat() {
        this(true, true);
    }

    private int parseInt(String pString, int pOffset, StringBuffer pDigits) {
        char c;
        int length = pString.length();
        pDigits.setLength(0);
        while (pOffset < length && Character.isDigit(c = pString.charAt(pOffset))) {
            pDigits.append(c);
            ++pOffset;
        }
        return pOffset;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object parseObject(String pString, ParsePosition pParsePosition) {
        int millis;
        int second;
        int minute;
        int hour;
        int mday;
        int month;
        int year;
        StringBuffer digits;
        boolean isMinus;
        int length;
        int offset;
        block21: {
            block29: {
                block34: {
                    block35: {
                        block33: {
                            block31: {
                                block32: {
                                    block30: {
                                        block20: {
                                            block22: {
                                                block27: {
                                                    block28: {
                                                        block26: {
                                                            block24: {
                                                                block25: {
                                                                    block23: {
                                                                        if (pString == null) {
                                                                            throw new NullPointerException("The String argument must not be null.");
                                                                        }
                                                                        if (pParsePosition == null) {
                                                                            throw new NullPointerException("The ParsePosition argument must not be null.");
                                                                        }
                                                                        offset = pParsePosition.getIndex();
                                                                        length = pString.length();
                                                                        isMinus = false;
                                                                        digits = new StringBuffer();
                                                                        if (!this.parseDate) break block22;
                                                                        if (offset < length) {
                                                                            char c = pString.charAt(offset);
                                                                            if (c == '+') {
                                                                                ++offset;
                                                                            } else if (c == '-') {
                                                                                ++offset;
                                                                                isMinus = true;
                                                                            }
                                                                        }
                                                                        offset = this.parseInt(pString, offset, digits);
                                                                        if (digits.length() < 4) {
                                                                            pParsePosition.setErrorIndex(offset);
                                                                            return null;
                                                                        }
                                                                        year = Integer.parseInt(digits.toString());
                                                                        if (offset >= length || pString.charAt(offset) != '-') break block23;
                                                                        ++offset;
                                                                        offset = this.parseInt(pString, offset, digits);
                                                                        if (digits.length() == 2) break block24;
                                                                        break block25;
                                                                    }
                                                                    pParsePosition.setErrorIndex(offset);
                                                                    return null;
                                                                }
                                                                pParsePosition.setErrorIndex(offset);
                                                                return null;
                                                            }
                                                            month = Integer.parseInt(digits.toString());
                                                            if (offset >= length || pString.charAt(offset) != '-') break block26;
                                                            ++offset;
                                                            offset = this.parseInt(pString, offset, digits);
                                                            if (digits.length() == 2) break block27;
                                                            break block28;
                                                        }
                                                        pParsePosition.setErrorIndex(offset);
                                                        return null;
                                                    }
                                                    pParsePosition.setErrorIndex(offset);
                                                    return null;
                                                }
                                                mday = Integer.parseInt(digits.toString());
                                                if (this.parseTime) {
                                                    if (offset < length && pString.charAt(offset) == 'T') {
                                                        ++offset;
                                                        break block20;
                                                    } else {
                                                        pParsePosition.setErrorIndex(offset);
                                                        return null;
                                                    }
                                                }
                                                break block20;
                                            }
                                            mday = 0;
                                            month = 0;
                                            year = 0;
                                        }
                                        if (!this.parseTime) break block29;
                                        offset = this.parseInt(pString, offset, digits);
                                        if (digits.length() != 2) {
                                            pParsePosition.setErrorIndex(offset);
                                            return null;
                                        }
                                        hour = Integer.parseInt(digits.toString());
                                        if (offset >= length || pString.charAt(offset) != ':') break block30;
                                        ++offset;
                                        offset = this.parseInt(pString, offset, digits);
                                        if (digits.length() == 2) break block31;
                                        break block32;
                                    }
                                    pParsePosition.setErrorIndex(offset);
                                    return null;
                                }
                                pParsePosition.setErrorIndex(offset);
                                return null;
                            }
                            minute = Integer.parseInt(digits.toString());
                            if (offset >= length || pString.charAt(offset) != ':') break block33;
                            ++offset;
                            offset = this.parseInt(pString, offset, digits);
                            if (digits.length() == 2) break block34;
                            break block35;
                        }
                        pParsePosition.setErrorIndex(offset);
                        return null;
                    }
                    pParsePosition.setErrorIndex(offset);
                    return null;
                }
                second = Integer.parseInt(digits.toString());
                if (offset < length && pString.charAt(offset) == '.') {
                    ++offset;
                    offset = this.parseInt(pString, offset, digits);
                    millis = digits.length() > 0 ? Integer.parseInt(digits.toString()) : 0;
                    break block21;
                } else {
                    millis = 0;
                }
                break block21;
            }
            millis = 0;
            second = 0;
            minute = 0;
            hour = 0;
        }
        digits.setLength(0);
        digits.append("GMT");
        if (offset < length) {
            char c = pString.charAt(offset);
            if (c == 'Z') {
                ++offset;
            } else if (c == '+' || c == '-') {
                digits.append(c);
                ++offset;
                for (int i = 0; i < 5; ++offset, ++i) {
                    if (offset >= length) {
                        pParsePosition.setErrorIndex(offset);
                        return null;
                    }
                    c = pString.charAt(offset);
                    if (i != 2 && Character.isDigit(c) || i == 2 && c == ':') {
                        digits.append(c);
                        continue;
                    }
                    pParsePosition.setErrorIndex(offset);
                    return null;
                }
            }
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(digits.toString()));
        cal.set(isMinus ? -year : year, month, mday, hour, minute, second);
        cal.set(14, millis);
        pParsePosition.setIndex(offset);
        return cal;
    }

    private void append(StringBuffer pBuffer, int pNum, int pMinLen) {
        String s = Integer.toString(pNum);
        for (int i = s.length(); i < pMinLen; ++i) {
            pBuffer.append('0');
        }
        pBuffer.append(s);
    }

    @Override
    public StringBuffer format(Object pCalendar, StringBuffer pBuffer, FieldPosition pPos) {
        TimeZone tz;
        int offset;
        if (pCalendar == null) {
            throw new NullPointerException("The Calendar argument must not be null.");
        }
        if (pBuffer == null) {
            throw new NullPointerException("The StringBuffer argument must not be null.");
        }
        if (pPos == null) {
            throw new NullPointerException("The FieldPosition argument must not be null.");
        }
        Calendar cal = (Calendar)pCalendar;
        if (this.parseDate) {
            int year = cal.get(1);
            if (year < 0) {
                pBuffer.append('-');
                year = -year;
            }
            this.append(pBuffer, year, 4);
            pBuffer.append('-');
            this.append(pBuffer, cal.get(2), 2);
            pBuffer.append('-');
            this.append(pBuffer, cal.get(5), 2);
            if (this.parseTime) {
                pBuffer.append('T');
            }
        }
        if (this.parseTime) {
            this.append(pBuffer, cal.get(11), 2);
            pBuffer.append(':');
            this.append(pBuffer, cal.get(12), 2);
            pBuffer.append(':');
            this.append(pBuffer, cal.get(13), 2);
            int millis = cal.get(14);
            if (millis > 0) {
                pBuffer.append('.');
                this.append(pBuffer, millis, 3);
            }
        }
        if ((offset = (tz = cal.getTimeZone()).getOffset(cal.getTimeInMillis())) == 0) {
            pBuffer.append('Z');
        } else {
            if (offset < 0) {
                pBuffer.append('-');
                offset = -offset;
            } else {
                pBuffer.append('+');
            }
            int minutes = offset / 60000;
            int hours = minutes / 60;
            this.append(pBuffer, hours, 2);
            pBuffer.append(':');
            this.append(pBuffer, minutes -= hours * 60, 2);
        }
        return pBuffer;
    }
}

