/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.cluster.advertise;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.jboss.web.cluster.ClusterListener;
import org.jboss.web.cluster.advertise.AdvertisedServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvertiseListener {
    public static int DEFAULT_PORT = 23364;
    public static String DEFAULT_GROUP = "224.0.1.105";
    private static String RFC_822_FMT = "EEE, d MMM yyyy HH:mm:ss Z";
    private int advertisePort = DEFAULT_PORT;
    private String groupAddress = DEFAULT_GROUP;
    private MulticastSocket ms;
    private SimpleDateFormat df;
    private boolean listening = true;
    private boolean initialized = false;
    private boolean running = false;
    private boolean paused = false;
    private boolean daemon = true;
    private byte[] secure = new byte[16];
    private String securityKey = null;
    private MessageDigest md = null;
    private HashMap<String, AdvertisedServer> servers;
    private ClusterListener listener;
    private Thread workerThread;

    private static void digestString(MessageDigest md, String s) {
        int len = s.length();
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            b[i] = c < '\u007f' ? (int)c : 63;
        }
        md.update(b);
    }

    public AdvertiseListener(ClusterListener listener) {
        this.df = new SimpleDateFormat(RFC_822_FMT, Locale.US);
        this.servers = new HashMap();
        this.listener = listener;
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setSecurityKey(String key) throws NoSuchAlgorithmException {
        this.securityKey = key;
        if (this.md == null) {
            this.md = MessageDigest.getInstance("MD5");
        }
    }

    public void setAdvertisePort(int port) {
        this.advertisePort = port;
    }

    public int getAdvertisePort() {
        return this.advertisePort;
    }

    public void setGroupAddress(String address) {
        this.groupAddress = address;
    }

    public String getGroupAddress() {
        return this.groupAddress;
    }

    public Collection<AdvertisedServer> getServers() {
        return this.servers.values();
    }

    public AdvertisedServer getServer(String name) {
        return this.servers.get(name);
    }

    public void removeServer(AdvertisedServer server) {
        this.servers.remove(server);
    }

    private String getSystemProperty(final String key) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(key);
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        };
        return AccessController.doPrivileged(action);
    }

    private void init() throws IOException {
        boolean linuxlike;
        String value = this.getSystemProperty("os.name");
        boolean bl = linuxlike = value != null && (value.toLowerCase().startsWith("linux") || value.toLowerCase().startsWith("mac") || value.toLowerCase().startsWith("hp"));
        if (this.groupAddress == null || !linuxlike) {
            this.ms = new MulticastSocket(this.advertisePort);
        } else {
            try {
                this.ms = new MulticastSocket(new InetSocketAddress(this.groupAddress, this.advertisePort));
            }
            catch (IOException e) {
                this.ms = new MulticastSocket(this.advertisePort);
            }
        }
        this.ms.setTimeToLive(0);
        this.ms.joinGroup(InetAddress.getByName(this.groupAddress));
        this.initialized = true;
    }

    private void interruptDatagramReader() {
        if (!this.initialized) {
            return;
        }
        try {
            this.ms.setTimeToLive(0);
            DatagramPacket dp = new DatagramPacket(this.secure, this.secure.length, InetAddress.getByName(this.groupAddress), this.advertisePort);
            this.ms.send(dp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() throws IOException {
        if (!this.initialized) {
            this.init();
        }
        if (!this.running) {
            SecureRandom random = new SecureRandom();
            random.nextBytes(this.secure);
            this.secure[0] = 0;
            this.running = true;
            this.paused = false;
            this.listening = true;
            AdvertiseListenerWorker aw = new AdvertiseListenerWorker();
            this.workerThread = new Thread(aw);
            this.workerThread.setDaemon(this.daemon);
            this.workerThread.start();
        }
    }

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.interruptDatagramReader();
        }
    }

    public void resume() {
        if (this.running && this.paused) {
            SecureRandom random = new SecureRandom();
            random.nextBytes(this.secure);
            this.secure[0] = 0;
            this.paused = false;
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.interruptDatagramReader();
            this.workerThread = null;
        }
    }

    public void destroy() throws IOException {
        if (this.running) {
            this.stop();
        }
        if (this.initialized) {
            this.ms.leaveGroup(InetAddress.getByName(this.groupAddress));
            this.ms.close();
            this.initialized = false;
            this.ms = null;
        }
    }

    private boolean verifyDigest(String digest, String server, String date, String sequence) {
        if (this.md == null) {
            return true;
        }
        this.md.reset();
        AdvertiseListener.digestString(this.md, this.securityKey);
        byte[] ssalt = this.md.digest();
        this.md.update(ssalt);
        AdvertiseListener.digestString(this.md, date);
        AdvertiseListener.digestString(this.md, sequence);
        AdvertiseListener.digestString(this.md, server);
        byte[] our = this.md.digest();
        if (our.length != digest.length() / 2) {
            return false;
        }
        int val = 0;
        for (int i = 0; i < digest.length(); ++i) {
            char ch = digest.charAt(i);
            if (i % 2 == 0) {
                val = ch >= 'A' ? (ch & 0xDF) - 65 + 10 : ch - 48;
                continue;
            }
            if (our[i / 2] == (byte)(val = val * 16 + (ch >= 'A' ? (ch & 0xDF) - 65 + 10 : ch - 48))) continue;
            return false;
        }
        return true;
    }

    public boolean isListening() {
        return this.listening;
    }

    private class AdvertiseListenerWorker
    implements Runnable {
        protected AdvertiseListenerWorker() {
        }

        public void run() {
            byte[] buffer = new byte[512];
            while (AdvertiseListener.this.running) {
                while (AdvertiseListener.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    String s;
                    DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
                    AdvertiseListener.this.ms.receive(dp);
                    if (!AdvertiseListener.this.running) break;
                    byte[] data = dp.getData();
                    boolean intr = false;
                    if (dp.getLength() == AdvertiseListener.this.secure.length) {
                        int i;
                        for (i = 0; i < AdvertiseListener.this.secure.length && data[i] == AdvertiseListener.this.secure[i]; ++i) {
                        }
                        if (i == AdvertiseListener.this.secure.length) {
                            intr = true;
                        }
                    }
                    if (intr || !(s = new String(data, 0, dp.getLength(), "8859_1")).startsWith("HTTP/1.")) continue;
                    String[] headers = s.split("\r\n");
                    String date_str = null;
                    Date date = null;
                    int status = 0;
                    String status_desc = null;
                    String digest = null;
                    String server_name = null;
                    String sequence = null;
                    AdvertisedServer server = null;
                    boolean added = false;
                    for (int i = 0; i < headers.length; ++i) {
                        if (i == 0) {
                            String[] sline = headers[i].split(" ", 3);
                            if (sline == null || sline.length != 3 || (status = Integer.parseInt(sline[1])) < 100) break;
                            status_desc = sline[2];
                            continue;
                        }
                        String[] hdrv = headers[i].split(": ", 2);
                        if (hdrv == null || hdrv.length != 2) break;
                        if (hdrv[0].equals("Date")) {
                            date_str = hdrv[1];
                            try {
                                date = AdvertiseListener.this.df.parse(date_str);
                            }
                            catch (ParseException e) {
                                date = new Date();
                            }
                            continue;
                        }
                        if (hdrv[0].equals("Digest")) {
                            digest = hdrv[1];
                            continue;
                        }
                        if (hdrv[0].equals("Sequence")) {
                            sequence = hdrv[1];
                            continue;
                        }
                        if (hdrv[0].equals("Server")) {
                            server_name = hdrv[1];
                            server = (AdvertisedServer)AdvertiseListener.this.servers.get(server_name);
                            if (server != null) continue;
                            server = new AdvertisedServer(server_name);
                            added = true;
                            continue;
                        }
                        if (server == null) continue;
                        server.setParameter(hdrv[0], hdrv[1]);
                    }
                    if (server != null && status > 0) {
                        if (AdvertiseListener.this.md != null && !AdvertiseListener.this.verifyDigest(digest, server_name, date_str, sequence)) continue;
                        server.setDate(date);
                        boolean rc = server.setStatus(status, status_desc);
                        if (added) {
                            AdvertiseListener.this.servers.put(server_name, server);
                            String proxy = server.getParameter(AdvertisedServer.MANAGER_ADDRESS);
                            if (proxy != null) {
                                AdvertiseListener.this.listener.addProxy(proxy);
                            }
                        } else if (rc) {
                            // empty if block
                        }
                    }
                    AdvertiseListener.this.listening = true;
                }
                catch (IOException e) {
                    AdvertiseListener.this.listening = false;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

