/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import xjavadoc.DefaultXTag;
import xjavadoc.UnknownTagException;
import xjavadoc.XDoc;
import xjavadoc.XTag;

public final class XTagFactory {
    private final Map _tagClasses = new HashMap();
    private boolean _isValidating = false;

    public XTagFactory() {
        this.setIgnoredTags("author,deprecated,exception,param,return,see,serial,serialData,serialField,since,throws,version");
    }

    public boolean isValidating() {
        return this._isValidating;
    }

    public void setValidating(boolean isValidating) {
        this._isValidating = isValidating;
    }

    public void setIgnoredTags(String tags) {
        StringTokenizer st = new StringTokenizer(tags, ",");
        while (st.hasMoreTokens()) {
            this.registerTagClass(st.nextToken(), DefaultXTag.class);
        }
    }

    public XTag createTag(String tagName, String text, XDoc doc, int lineNumber) throws UnknownTagException {
        DefaultXTag tag;
        Class tagClass = (Class)this._tagClasses.get(tagName = XDoc.dotted(tagName));
        if (tagClass != null) {
            try {
                tag = (DefaultXTag)tagClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
        } else {
            tag = new DefaultXTag();
        }
        tag.init(tagName, text, doc, lineNumber);
        if (this._isValidating && tagClass == null) {
            throw new UnknownTagException(tag);
        }
        return tag;
    }

    public void registerTagClass(String tagName, Class tagClass) {
        Class old = (Class)this._tagClasses.get(XDoc.dotted(tagName));
        if (old != null) {
            throw new IllegalStateException("The tag @" + XDoc.dotted(tagName) + " has already been mapped to " + old.getName() + ". Can't reregister it to " + tagClass.getName());
        }
        this._tagClasses.put(XDoc.dotted(tagName), tagClass);
    }
}

