/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.on.embedded.bean.MeasurementComparator;
import org.jboss.on.embedded.bean.MeasurementDisplay;
import org.jboss.on.embedded.bean.MeasurementIntegerValueAndUnits;
import org.jboss.on.embedded.bean.ResourceListItem;
import org.jboss.on.embedded.util.MeasurementConversionUtility;
import org.rhq.core.clientapi.agent.measurement.MeasurementAgentService;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementNumericValueAndUnits;
import org.rhq.core.domain.measurement.composite.MeasurementStringValueAndUnits;
import org.rhq.core.domain.measurement.composite.MeasurementValueAndUnits;
import org.rhq.core.domain.measurement.util.MeasurementConversionException;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementUtils {
    private ResourceListItem resource;
    private ResourceType resourceType;
    private Map<String, MeasurementDefinition> measurementDefinitionMap = new HashMap<String, MeasurementDefinition>();

    public MeasurementUtils(ResourceListItem resource) {
        this.resource = resource;
        this.resourceType = this.resource.getResource().getResourceType();
        this.measurementDefinitionMap = new HashMap<String, MeasurementDefinition>();
        Set metricDefinitions = this.resourceType.getMetricDefinitions();
        for (MeasurementDefinition measurementDefinition : metricDefinitions) {
            if (measurementDefinition.isPerMinute()) continue;
            this.measurementDefinitionMap.put(measurementDefinition.getName(), measurementDefinition);
        }
    }

    public List<MeasurementData> loadMeasurementData(DisplayType displayType, DataType dataType) {
        HashMap<String, MeasurementDefinition> requestedMetricDefs = new HashMap<String, MeasurementDefinition>();
        for (MeasurementDefinition metricDef : this.measurementDefinitionMap.values()) {
            if (displayType != null && dataType != null) {
                if (!metricDef.getDisplayType().equals((Object)displayType) || !metricDef.getDataType().equals((Object)dataType)) continue;
                requestedMetricDefs.put(metricDef.getName(), metricDef);
                continue;
            }
            if (dataType != null) {
                if (!metricDef.getDataType().equals((Object)dataType)) continue;
                requestedMetricDefs.put(metricDef.getName(), metricDef);
                continue;
            }
            if (displayType == null || !metricDef.getDisplayType().equals((Object)displayType)) continue;
            requestedMetricDefs.put(metricDef.getName(), metricDef);
        }
        MeasurementAgentService measurementAgentService = PluginContainer.getInstance().getMeasurementAgentService();
        int resourceId = this.resource.getResource().getId();
        String[] measurementNamesArray = requestedMetricDefs.keySet().toArray(new String[requestedMetricDefs.size()]);
        Set measurementDataSet = measurementAgentService.getRealTimeMeasurementValue(resourceId, dataType, measurementNamesArray);
        ArrayList measurementDataList = null;
        if (measurementDataSet != null) {
            measurementDataList = new ArrayList(measurementDataSet);
            Collections.sort(measurementDataList, new MeasurementComparator(requestedMetricDefs));
        }
        return measurementDataList;
    }

    public List<String> loadCategoryList(Map<String, MeasurementDefinition> measurementDefinitionMap, List<MeasurementData> measurementDataList, Map<String, List<MeasurementDisplay>> measurementDisplayMap) {
        if (measurementDataList != null) {
            for (MeasurementData measurementData : measurementDataList) {
                MeasurementDefinition measurementDefinition = measurementDefinitionMap.get(measurementData.getName());
                String category = measurementDefinition.getCategory().toString();
                List<MeasurementDisplay> list = measurementDisplayMap.get(category);
                if (list == null) {
                    list = new ArrayList<MeasurementDisplay>();
                    measurementDisplayMap.put(category, list);
                }
                list.add(this.createMeasurementDisplay(measurementData, measurementDefinition));
            }
        }
        return new ArrayList<String>(measurementDisplayMap.keySet());
    }

    public MeasurementDisplay createMeasurementDisplay(MeasurementData measurementData, MeasurementDefinition measurementDefinition) {
        MeasurementDisplay measurementDisplay = new MeasurementDisplay(measurementData, measurementDefinition);
        measurementDisplay.getMeasurementDefinition().getUnits();
        if (measurementDisplay.getMeasurementData().getValue() instanceof Double) {
            try {
                Double dbl;
                double dataValue = (Double)measurementDisplay.getMeasurementData().getValue();
                MeasurementUnits units = measurementDisplay.getMeasurementDefinition().getUnits();
                Object dataValueAndUnits = units == MeasurementUnits.NONE ? (dataValue != (double)(dbl = Double.valueOf(dataValue)).intValue() ? MeasurementConversionUtility.fit(dataValue, units) : new MeasurementIntegerValueAndUnits(dataValue, units)) : MeasurementConversionUtility.fit(dataValue, units);
                measurementDisplay.setMeasurementValueAndUnits((MeasurementValueAndUnits)dataValueAndUnits);
            }
            catch (MeasurementConversionException mce) {
                measurementDisplay.setMeasurementValueAndUnits((MeasurementValueAndUnits)MeasurementNumericValueAndUnits.ERROR);
            }
        } else if (measurementDisplay.getMeasurementData().getValue() instanceof String) {
            String dataValue = (String)measurementDisplay.getMeasurementData().getValue();
            measurementDisplay.setMeasurementValueAndUnits((MeasurementValueAndUnits)new MeasurementStringValueAndUnits(dataValue, MeasurementUnits.NONE));
        }
        return measurementDisplay;
    }

    public Map<String, MeasurementDefinition> getMeasurementDefinitionMap() {
        return this.measurementDefinitionMap;
    }
}

